/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.commands;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.chasem.cobblemonextras.CobblemonExtras;
import dev.chasem.cobblemonextras.permissions.CobblemonExtrasPermissions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Ldev/chasem/cobblemonextras/commands/PokeIVs;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "execute", "(Lcom/mojang/brigadier/context/CommandContext;)I", "common"})
public final class PokeIVs {
    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pokeivs").requires(PokeIVs::register$lambda$0)).executes(arg_0 -> PokeIVs.register$lambda$1(this, arg_0)));
    }

    private final int execute(CommandContext<CommandSourceStack> ctx) {
        if (((CommandSourceStack)ctx.getSource()).getPlayer() != null) {
            ServerPlayer serverPlayer = ((CommandSourceStack)ctx.getSource()).getPlayer();
            Intrinsics.checkNotNull((Object)serverPlayer);
            ServerPlayer player = serverPlayer;
            PokemonBattle battle = BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player);
            if (battle == null) {
                player.sendSystemMessage((Component)Component.literal((String)"You are not currently in a battle.").withStyle(ChatFormatting.RED));
                return 1;
            }
            BattleActor playerActor = battle.getActor(player);
            BattleSide side = null;
            for (BattleActor battleActor : battle.getSide1().getActors()) {
                BattleActor battleActor2 = playerActor;
                if (!Intrinsics.areEqual((Object)(battleActor2 != null ? battleActor2.getUuid() : null), (Object)battleActor.getUuid())) continue;
                side = battle.getSide2();
                break;
            }
            if (side == null) {
                side = battle.getSide1();
            }
            for (ActiveBattlePokemon activeBattlePokemon : side.getActivePokemon()) {
                if (activeBattlePokemon.getBattlePokemon() != null) {
                    BattlePokemon battlePokemon = activeBattlePokemon.getBattlePokemon();
                    Intrinsics.checkNotNull((Object)battlePokemon);
                    Pokemon pokemon = battlePokemon.getOriginalPokemon();
                    MutableComponent hoveredText = Component.literal((String)"").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(false)));
                    MutableComponent header = pokemon.getDisplayName().withStyle(Style.EMPTY.withColor(ChatFormatting.WHITE).withUnderlined(Boolean.valueOf(true)));
                    MutableComponent line1 = Component.literal((String)"HP: ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.HP))).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" Atk: ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.ATTACK))).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)" Def: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.DEFENCE))).withStyle(ChatFormatting.WHITE)));
                    MutableComponent line2 = Component.literal((String)"SpAtk: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_ATTACK))).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" SpDef: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_DEFENCE))).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)" Spd: ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPEED))).withStyle(ChatFormatting.WHITE)));
                    hoveredText.append((Component)header).append((Component)Component.literal((String)"\n")).append((Component)line1).append((Component)Component.literal((String)"\n")).append((Component)line2);
                    MutableComponent text = pokemon.getDisplayName().withStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)).append((Component)Component.literal((String)" IVs").withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)hoveredText))));
                    player.sendSystemMessage((Component)Component.literal((String)"[").append((Component)text).append("]"));
                    continue;
                }
                player.sendSystemMessage((Component)Component.literal((String)"You are not currently in a battle.").withStyle(ChatFormatting.RED));
                return 1;
            }
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"Sorry, this is only for players."));
        }
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack src) {
        return CobblemonExtrasPermissions.Companion.checkPermission(src, CobblemonExtras.INSTANCE.getPermissions().getPOKEIVS_PERMISSION());
    }

    private static final int register$lambda$1(PokeIVs this$0, CommandContext ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return this$0.execute((CommandContext<CommandSourceStack>)ctx);
    }
}

