/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.menus;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.storage.NoPokemonStoreException;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.api.storage.pc.PCBox;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.chasem.cobblemonextras.util.ItemBuilder;
import dev.chasem.cobblemonextras.util.PokemonUtility;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u0016\u0010 \u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010!\u00a8\u0006\""}, d2={"Ldev/chasem/cobblemonextras/menus/CompSeeMenu;", "Lnet/minecraft/world/MenuProvider;", "Lnet/minecraft/server/level/ServerPlayer;", "playerToView", "", "boxNumber", "<init>", "(Lnet/minecraft/server/level/ServerPlayer;I)V", "", "fillWithPanes", "()V", "setupContainer", "getNextBox", "()I", "getPreviousBox", "displayBox", "(I)V", "i", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "createMenu", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/inventory/AbstractContainerMenu;", "Lnet/minecraft/network/chat/Component;", "getDisplayName", "()Lnet/minecraft/network/chat/Component;", "Lnet/minecraft/world/Container;", "container", "Lnet/minecraft/world/Container;", "Lnet/minecraft/server/level/ServerPlayer;", "MAX_BOX_COUNT", "I", "common"})
public final class CompSeeMenu
implements MenuProvider {
    @NotNull
    private final Container container;
    @Nullable
    private ServerPlayer playerToView;
    private int MAX_BOX_COUNT;
    private int boxNumber;

    public CompSeeMenu(@NotNull ServerPlayer playerToView, int boxNumber) {
        Intrinsics.checkNotNullParameter((Object)playerToView, (String)"playerToView");
        this.container = (Container)new SimpleContainer(54);
        this.MAX_BOX_COUNT = Cobblemon.INSTANCE.getConfig().getDefaultBoxCount();
        this.playerToView = playerToView;
        this.setupContainer();
        this.displayBox(0);
    }

    private final void fillWithPanes() {
        int n = this.container.getContainerSize();
        for (int i = 0; i < n; ++i) {
            this.container.setItem(i, new ItemBuilder(Items.WHITE_STAINED_GLASS_PANE).setCustomName((Component)Component.literal((String)" ")).build());
        }
    }

    private final void setupContainer() {
        this.fillWithPanes();
    }

    private final int getNextBox() {
        int newBox = this.boxNumber + 1;
        if (newBox >= this.MAX_BOX_COUNT) {
            newBox = 0;
        }
        return newBox;
    }

    private final int getPreviousBox() {
        int newBox = this.boxNumber - 1;
        if (newBox < 0) {
            newBox = this.MAX_BOX_COUNT - 1;
        }
        return newBox;
    }

    private final void displayBox(int boxNumber) {
        List list;
        this.boxNumber = boxNumber;
        this.container.setChanged();
        Container container = this.container;
        if (container != null) {
            container.setItem(42, new ItemBuilder(Items.ARROW).hideAdditional().setCustomName((Component)Component.literal((String)("Goto Box " + (this.getPreviousBox() + 1)))).build());
        }
        Container container2 = this.container;
        if (container2 != null) {
            container2.setItem(43, new ItemBuilder((Item)CobblemonItems.PC).hideAdditional().setCustomName((Component)Component.literal((String)("Current Box " + (boxNumber + 1)))).build());
        }
        Container container3 = this.container;
        if (container3 != null) {
            container3.setItem(44, new ItemBuilder(Items.ARROW).hideAdditional().setCustomName((Component)Component.literal((String)("Goto Box " + (this.getNextBox() + 1)))).build());
        }
        List pcStore = null;
        try {
            PokemonStoreManager pokemonStoreManager = Cobblemon.INSTANCE.getStorage();
            ServerPlayer serverPlayer = this.playerToView;
            Intrinsics.checkNotNull((Object)serverPlayer);
            pcStore = pokemonStoreManager.getPC(serverPlayer);
        }
        catch (NoPokemonStoreException noPokemonStoreException) {
            // empty catch block
        }
        PCBox box = (list = pcStore) != null && (list = list.getBoxes()) != null ? (PCBox)list.get(boxNumber) : null;
        int n = this.container.getContainerSize();
        for (int i = 0; i < n && i < 30; ++i) {
            PCBox pCBox = box;
            Pokemon pokemon = pCBox != null ? pCBox.get(i) : null;
            double row = Math.floor((double)i / 6.0);
            int index = i % 6;
            if (pokemon != null) {
                ItemStack item = PokemonUtility.INSTANCE.pokemonToItem(pokemon);
                this.container.setItem((int)(row * (double)9) + index, item);
                continue;
            }
            this.container.setItem((int)(row * (double)9) + index, new ItemBuilder(Items.RED_STAINED_GLASS_PANE).setCustomName((Component)Component.literal((String)"Empty").withStyle(ChatFormatting.GRAY)).build());
        }
    }

    @NotNull
    public AbstractContainerMenu createMenu(int i, @Nullable Inventory inventory, @Nullable Player player) {
        MenuType menuType = MenuType.GENERIC_9x6;
        Container container = this.container;
        return (AbstractContainerMenu)new ChestMenu(i, inventory, this, (MenuType<ChestMenu>)menuType, container){
            final /* synthetic */ CompSeeMenu this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $i, $inventory, $super_call_param$2, 6);
            }

            public void clicked(int slot, int buttonNo, ClickType clickType, Player player) {
                Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                switch (slot) {
                    case 42: {
                        CompSeeMenu.access$displayBox(this.this$0, CompSeeMenu.access$getPreviousBox(this.this$0));
                        break;
                    }
                    case 44: {
                        CompSeeMenu.access$displayBox(this.this$0, CompSeeMenu.access$getNextBox(this.this$0));
                    }
                }
            }

            public ItemStack quickMoveStack(Player player, int i) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }

            public boolean stillValid(Player player) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return true;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        ServerPlayer serverPlayer = this.playerToView;
        Object object = serverPlayer != null ? serverPlayer.getName() : null;
        Intrinsics.checkNotNull((Object)object);
        MutableComponent mutableComponent = Component.literal((String)(Component.literal((String)object.getString()).withStyle(ChatFormatting.DARK_GRAY).getString() + " PC"));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return (Component)mutableComponent;
    }

    public static final /* synthetic */ void access$displayBox(CompSeeMenu $this, int boxNumber) {
        $this.displayBox(boxNumber);
    }

    public static final /* synthetic */ int access$getPreviousBox(CompSeeMenu $this) {
        return $this.getPreviousBox();
    }

    public static final /* synthetic */ int access$getNextBox(CompSeeMenu $this) {
        return $this.getNextBox();
    }
}

