/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.menus;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.PokemonStoreManager;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.chasem.cobblemonextras.util.ItemBuilder;
import dev.chasem.cobblemonextras.util.PokemonUtility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ+\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019\u00a8\u0006\u001a"}, d2={"Ldev/chasem/cobblemonextras/menus/PokeSeeMenu;", "Lnet/minecraft/world/MenuProvider;", "Lnet/minecraft/server/level/ServerPlayer;", "playerToView", "<init>", "(Lnet/minecraft/server/level/ServerPlayer;)V", "", "fillWithPanes", "()V", "setupContainer", "", "i", "Lnet/minecraft/world/entity/player/Inventory;", "inventory", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "createMenu", "(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/inventory/AbstractContainerMenu;", "Lnet/minecraft/network/chat/Component;", "getDisplayName", "()Lnet/minecraft/network/chat/Component;", "Lnet/minecraft/world/Container;", "container", "Lnet/minecraft/world/Container;", "Lnet/minecraft/server/level/ServerPlayer;", "common"})
public final class PokeSeeMenu
implements MenuProvider {
    @NotNull
    private final Container container;
    @Nullable
    private ServerPlayer playerToView;

    public PokeSeeMenu(@NotNull ServerPlayer playerToView) {
        Intrinsics.checkNotNullParameter((Object)playerToView, (String)"playerToView");
        this.container = (Container)new SimpleContainer(36);
        this.playerToView = playerToView;
        this.setupContainer();
    }

    private final void fillWithPanes() {
        int n = this.container.getContainerSize();
        for (int i = 0; i < n; ++i) {
            this.container.setItem(i, new ItemBuilder(Items.GRAY_STAINED_GLASS_PANE).setCustomName((Component)Component.literal((String)" ")).build());
        }
    }

    private final void setupContainer() {
        this.fillWithPanes();
    }

    @NotNull
    public AbstractContainerMenu createMenu(int i, @Nullable Inventory inventory, @Nullable Player player) {
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (this.playerToView != null) {
            serverPlayer = this.playerToView;
        }
        PokemonStoreManager pokemonStoreManager = Cobblemon.INSTANCE.getStorage();
        ServerPlayer serverPlayer2 = serverPlayer;
        Intrinsics.checkNotNull((Object)serverPlayer2);
        PlayerPartyStore storage = pokemonStoreManager.getParty(serverPlayer2);
        for (int i2 = 0; i2 < 6; ++i2) {
            Pokemon pokemon = storage.get(i2);
            if (pokemon != null) {
                ItemStack item = PokemonUtility.INSTANCE.pokemonToItem(pokemon);
                this.container.setItem(12 + i2 + (i2 >= 3 ? 6 : 0), item);
                continue;
            }
            this.container.setItem(12 + i2 + (i2 >= 3 ? 6 : 0), new ItemBuilder(Items.RED_STAINED_GLASS_PANE).setCustomName((Component)Component.literal((String)"Empty").withStyle(ChatFormatting.GRAY)).build());
        }
        MenuType menuType = MenuType.GENERIC_9x4;
        Container container = this.container;
        return (AbstractContainerMenu)new ChestMenu(i, inventory, (MenuType<ChestMenu>)menuType, container){

            public void clicked(int slot, int buttonNo, ClickType clickType, Player player) {
                Intrinsics.checkNotNullParameter((Object)clickType, (String)"clickType");
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            }

            public ItemStack quickMoveStack(Player player, int i) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }

            public boolean stillValid(Player player) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                return true;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        ServerPlayer serverPlayer = this.playerToView;
        Object object = serverPlayer != null ? serverPlayer.getName() : null;
        Intrinsics.checkNotNull((Object)object);
        MutableComponent mutableComponent = Component.literal((String)(object.getString() + " Party"));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return (Component)mutableComponent;
    }
}

