/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.services;

import com.cobblemon.mod.common.api.interaction.RequestManager;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.battles.BattleBuilder;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.ChallengeManager;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.net.messages.client.battle.BattleChallengeExpiredPacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleChallengeNotificationPacket;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000e\u0010\fJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016R#\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Ldev/chasem/cobblemonextras/services/PVPChallengeService;", "Lcom/cobblemon/mod/common/api/interaction/RequestManager;", "Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;", "<init>", "()V", "request", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "expirationPacket", "(Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;)Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "notificationPacket", "", "onDecline", "(Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;)V", "onSend", "onAccept", "Lnet/minecraft/server/level/ServerPlayer;", "player", "target", "", "isValidInteraction", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/level/ServerPlayer;)Z", "canAccept", "(Lcom/cobblemon/mod/common/battles/ChallengeManager$BattleChallenge;)Z", "", "Ljava/util/UUID;", "selectedLead", "Ljava/util/Map;", "getSelectedLead", "()Ljava/util/Map;", "common"})
public final class PVPChallengeService
extends RequestManager<ChallengeManager.BattleChallenge> {
    @NotNull
    public static final PVPChallengeService INSTANCE = new PVPChallengeService();
    @NotNull
    private static final Map<UUID, UUID> selectedLead;

    private PVPChallengeService() {
    }

    @NotNull
    public final Map<UUID, UUID> getSelectedLead() {
        return selectedLead;
    }

    @NotNull
    protected NetworkPacket<?> expirationPacket(@NotNull ChallengeManager.BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (NetworkPacket)new BattleChallengeExpiredPacket(request);
    }

    @NotNull
    protected NetworkPacket<?> notificationPacket(@NotNull ChallengeManager.BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return (NetworkPacket)new BattleChallengeNotificationPacket(request);
    }

    protected void onDecline(@NotNull ChallengeManager.BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object[] objectArray = new Object[2];
        MutableComponent mutableComponent = request.getReceiver().getName().copy();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
        objectArray[0] = TextKt.aqua((MutableComponent)mutableComponent);
        objectArray[1] = request.getBattleFormat().getBattleType().getDisplayName();
        request.notifySender(true, "decline.sender", objectArray);
        objectArray = new Object[2];
        MutableComponent mutableComponent2 = request.getSender().getName().copy();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"copy(...)");
        objectArray[0] = TextKt.aqua((MutableComponent)mutableComponent2);
        objectArray[1] = request.getBattleFormat().getBattleType().getDisplayName();
        request.notifyReceiver(false, "decline.receiver", objectArray);
    }

    protected void onSend(@NotNull ChallengeManager.BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object[] objectArray = new Object[2];
        MutableComponent mutableComponent = request.getReceiver().getName().copy();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
        objectArray[0] = TextKt.aqua((MutableComponent)mutableComponent);
        objectArray[1] = request.getBattleFormat().getBattleType().getDisplayName();
        request.notifySender(false, "sent", objectArray);
        objectArray = new Object[2];
        MutableComponent mutableComponent2 = request.getSender().getName().copy();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"copy(...)");
        objectArray[0] = TextKt.aqua((MutableComponent)mutableComponent2);
        objectArray[1] = request.getBattleFormat().getBattleType().getDisplayName();
        request.notifyReceiver(false, "received", objectArray);
    }

    protected void onAccept(@NotNull ChallengeManager.BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        BattleBuilder.pvp1v1$default((BattleBuilder)BattleBuilder.INSTANCE, (ServerPlayer)request.getReceiver(), (ServerPlayer)request.getSender(), (UUID)selectedLead.get(request.getReceiver().getUUID()), (UUID)selectedLead.get(request.getSender().getUUID()), (BattleFormat)request.getBattleFormat(), (boolean)false, (boolean)false, null, (int)224, null).ifErrored(arg_0 -> PVPChallengeService.onAccept$lambda$2(request, arg_0));
    }

    public boolean isValidInteraction(@NotNull ServerPlayer player, @NotNull ServerPlayer target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return true;
    }

    protected boolean canAccept(@NotNull ChallengeManager.BattleChallenge request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (CollectionsKt.none((Iterable)((Iterable)PlayerExtensionsKt.party((ServerPlayer)request.getReceiver())))) {
            Object[] objectArray = new Object[1];
            MutableComponent mutableComponent = request.getReceiver().getName().copy();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
            objectArray[0] = TextKt.aqua((MutableComponent)mutableComponent);
            request.notifySender(true, "error.insufficient_pokemon.other", objectArray);
            request.notifyReceiver(true, "error.insufficient_pokemon.self", new Object[0]);
        } else if (CollectionsKt.none((Iterable)((Iterable)PlayerExtensionsKt.party((ServerPlayer)request.getSender())))) {
            request.notifySender(true, "error.insufficient_pokemon.self", new Object[0]);
            Object[] objectArray = new Object[1];
            MutableComponent mutableComponent = request.getSender().getName().copy();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"copy(...)");
            objectArray[0] = TextKt.aqua((MutableComponent)mutableComponent);
            request.notifyReceiver(true, "error.insufficient_pokemon.other", objectArray);
        } else {
            return true;
        }
        return false;
    }

    private static final MutableComponent onAccept$lambda$2$lambda$0(MutableComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TextKt.red((MutableComponent)it);
    }

    private static final MutableComponent onAccept$lambda$2$lambda$1(MutableComponent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TextKt.red((MutableComponent)it);
    }

    private static final Unit onAccept$lambda$2(ChallengeManager.BattleChallenge $request, ErroredBattleStart it) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.sendTo((Entity)$request.getReceiver(), PVPChallengeService::onAccept$lambda$2$lambda$0);
        it.sendTo((Entity)$request.getSender(), PVPChallengeService::onAccept$lambda$2$lambda$1);
        return Unit.INSTANCE;
    }

    static {
        RequestManager.Companion.register((RequestManager)INSTANCE);
        selectedLead = new LinkedHashMap();
    }
}

