/*
 * Decompiled with CFR 0.152.
 */
package dev.chasem.cobblemonextras.util;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.item.PokemonItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import dev.chasem.cobblemonextras.util.ItemBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/chasem/cobblemonextras/util/PokemonUtility;", "", "<init>", "()V", "Lnet/minecraft/network/chat/MutableComponent;", "toSend", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "Lnet/minecraft/network/chat/Component;", "getHoverText", "(Lnet/minecraft/network/chat/MutableComponent;Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/network/chat/Component;", "Lnet/minecraft/world/item/ItemStack;", "pokemonToItem", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lnet/minecraft/world/item/ItemStack;", "common"})
public final class PokemonUtility {
    @NotNull
    public static final PokemonUtility INSTANCE = new PokemonUtility();

    private PokemonUtility() {
    }

    @NotNull
    public final Component getHoverText(@NotNull MutableComponent toSend, @NotNull Pokemon pokemon) {
        String string;
        String moveThree;
        String moveTwo;
        String moveOne;
        Intrinsics.checkNotNullParameter((Object)toSend, (String)"toSend");
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        MutableComponent statsHoverText = Component.literal((String)"").withStyle(Style.EMPTY);
        if (pokemon.getShiny()) {
            statsHoverText.append((Component)Component.literal((String)" \u2605").withStyle(ChatFormatting.GOLD));
        }
        statsHoverText.append((Component)pokemon.getSpecies().getTranslatedName().copy().withStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN).withUnderlined(Boolean.valueOf(true))));
        statsHoverText.append((Component)Component.literal((String)"\n"));
        if (pokemon.getNickname() != null) {
            MutableComponent mutableComponent = Component.literal((String)"Nickname: ").withStyle(ChatFormatting.GRAY);
            MutableComponent mutableComponent2 = pokemon.getNickname();
            Intrinsics.checkNotNull((Object)mutableComponent2);
            statsHoverText.append((Component)mutableComponent.append((Component)Component.literal((String)mutableComponent2.getString()).withStyle(ChatFormatting.WHITE)));
            statsHoverText.append((Component)Component.literal((String)"\n"));
        }
        statsHoverText.append((Component)Component.literal((String)"Level: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(pokemon.getLevel())).withStyle(ChatFormatting.WHITE)));
        statsHoverText.append((Component)Component.literal((String)"\n"));
        statsHoverText.append((Component)Component.literal((String)"Nature: ").withStyle(ChatFormatting.YELLOW).append((Component)LocalizationUtilsKt.lang((String)StringsKt.replace$default((String)pokemon.getNature().getDisplayName(), (String)"cobblemon.", (String)"", (boolean)false, (int)4, null), (Object[])new Object[0]).withStyle(ChatFormatting.WHITE)));
        statsHoverText.append((Component)Component.literal((String)"\n"));
        statsHoverText.append((Component)Component.literal((String)"Ability: ").withStyle(ChatFormatting.GOLD).append((Component)LocalizationUtilsKt.lang((String)StringsKt.replace$default((String)pokemon.getAbility().getDisplayName(), (String)"cobblemon.", (String)"", (boolean)false, (int)4, null), (Object[])new Object[0]).withStyle(ChatFormatting.WHITE)));
        statsHoverText.append((Component)Component.literal((String)"\n"));
        statsHoverText.append((Component)Component.literal((String)"Form: ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)pokemon.getForm().getName()).withStyle(ChatFormatting.WHITE)));
        MutableComponent statsText = Component.literal((String)"[Stats]").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)statsHoverText)));
        toSend.append((Component)statsText);
        double allEvs = pokemon.getEvs().getOrDefault((Stat)Stats.HP) + pokemon.getEvs().getOrDefault((Stat)Stats.ATTACK) + pokemon.getEvs().getOrDefault((Stat)Stats.DEFENCE) + pokemon.getEvs().getOrDefault((Stat)Stats.SPECIAL_ATTACK) + pokemon.getEvs().getOrDefault((Stat)Stats.SPECIAL_DEFENCE) + pokemon.getEvs().getOrDefault((Stat)Stats.SPEED);
        double avg = allEvs / 510.0;
        double evPercent = (double)Math.round(avg * (double)10000) / (double)100;
        MutableComponent evsText = Component.literal((String)"[EVs]").withStyle(ChatFormatting.GOLD);
        MutableComponent evsHoverText = Component.literal((String)"").withStyle(Style.EMPTY);
        evsHoverText.append((Component)Component.literal((String)("EVs (" + evPercent + "%) ")).withStyle(Style.EMPTY.withColor(ChatFormatting.GOLD).withUnderlined(Boolean.valueOf(true))));
        evsHoverText.append((Component)Component.literal((String)"\n").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(false))));
        evsHoverText.append((Component)Component.literal((String)"HP: ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.HP))).withStyle(ChatFormatting.WHITE)));
        evsHoverText.append((Component)Component.literal((String)"\n"));
        evsHoverText.append((Component)Component.literal((String)"Attack: ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.ATTACK))).withStyle(ChatFormatting.WHITE)));
        evsHoverText.append((Component)Component.literal((String)"\n"));
        evsHoverText.append((Component)Component.literal((String)"Defense: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.DEFENCE))).withStyle(ChatFormatting.WHITE)));
        evsHoverText.append((Component)Component.literal((String)"\n"));
        evsHoverText.append((Component)Component.literal((String)"Sp. Attack: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.SPECIAL_ATTACK))).withStyle(ChatFormatting.WHITE)));
        evsHoverText.append((Component)Component.literal((String)"\n"));
        evsHoverText.append((Component)Component.literal((String)"Sp. Defense: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.SPECIAL_DEFENCE))).withStyle(ChatFormatting.WHITE)));
        evsHoverText.append((Component)Component.literal((String)"\n"));
        evsHoverText.append((Component)Component.literal((String)"Speed: ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.SPEED))).withStyle(ChatFormatting.WHITE)));
        evsText.setStyle(evsText.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)evsHoverText)));
        toSend.append((Component)evsText);
        int allIvs = pokemon.getIvs().getOrDefault((Stat)Stats.HP) + pokemon.getIvs().getOrDefault((Stat)Stats.ATTACK) + pokemon.getIvs().getOrDefault((Stat)Stats.DEFENCE) + pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_ATTACK) + pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_DEFENCE) + pokemon.getIvs().getOrDefault((Stat)Stats.SPEED);
        double ivAvg = (double)allIvs / 186.0;
        double ivPercent = (double)Math.round(ivAvg * (double)10000) / (double)100;
        MutableComponent ivsText = Component.literal((String)"[IVs]").withStyle(ChatFormatting.LIGHT_PURPLE);
        MutableComponent ivsHoverText = Component.literal((String)"").withStyle(Style.EMPTY);
        ivsHoverText.append((Component)Component.literal((String)("IVs (" + ivPercent + "%)")).withStyle(Style.EMPTY.withColor(ChatFormatting.LIGHT_PURPLE).withUnderlined(Boolean.valueOf(true))));
        ivsHoverText.append((Component)Component.literal((String)"\n").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(false))));
        ivsHoverText.append((Component)Component.literal((String)"HP: ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.HP))).withStyle(ChatFormatting.WHITE)));
        ivsHoverText.append((Component)Component.literal((String)"\n"));
        ivsHoverText.append((Component)Component.literal((String)"Attack: ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.ATTACK))).withStyle(ChatFormatting.WHITE)));
        ivsHoverText.append((Component)Component.literal((String)"\n"));
        ivsHoverText.append((Component)Component.literal((String)"Defense: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.DEFENCE))).withStyle(ChatFormatting.WHITE)));
        ivsHoverText.append((Component)Component.literal((String)"\n"));
        ivsHoverText.append((Component)Component.literal((String)"Sp. Attack: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_ATTACK))).withStyle(ChatFormatting.WHITE)));
        ivsHoverText.append((Component)Component.literal((String)"\n"));
        ivsHoverText.append((Component)Component.literal((String)"Sp. Defense: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_DEFENCE))).withStyle(ChatFormatting.WHITE)));
        ivsHoverText.append((Component)Component.literal((String)"\n"));
        ivsHoverText.append((Component)Component.literal((String)"Speed: ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPEED))).withStyle(ChatFormatting.WHITE)));
        ivsText.setStyle(ivsText.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)ivsHoverText)));
        toSend.append((Component)ivsText);
        MutableComponent movesText = Component.literal((String)"[Moves]").withStyle(ChatFormatting.BLUE);
        MutableComponent movesHoverText = Component.literal((String)"").withStyle(Style.EMPTY);
        movesHoverText.append((Component)Component.literal((String)"Moves").withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true))));
        movesHoverText.append((Component)Component.literal((String)"\n").withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(false))));
        if (pokemon.getMoveSet().getMoves().size() >= 1) {
            Move move = pokemon.getMoveSet().get(0);
            Intrinsics.checkNotNull((Object)move);
            v3 = move.getDisplayName().getString();
        } else {
            v3 = moveOne = "Empty";
        }
        if (pokemon.getMoveSet().getMoves().size() >= 2) {
            Move move = pokemon.getMoveSet().get(1);
            Intrinsics.checkNotNull((Object)move);
            v5 = move.getDisplayName().getString();
        } else {
            v5 = moveTwo = "Empty";
        }
        if (pokemon.getMoveSet().getMoves().size() >= 3) {
            Move move = pokemon.getMoveSet().get(2);
            Intrinsics.checkNotNull((Object)move);
            v7 = move.getDisplayName().getString();
        } else {
            v7 = moveThree = "Empty";
        }
        if (pokemon.getMoveSet().getMoves().size() >= 4) {
            Move move = pokemon.getMoveSet().get(3);
            Intrinsics.checkNotNull((Object)move);
            string = move.getDisplayName().getString();
        } else {
            string = "Empty";
        }
        String moveFour = string;
        movesHoverText.append((Component)Component.literal((String)"Move 1: ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)moveOne).withStyle(ChatFormatting.WHITE)));
        movesHoverText.append((Component)Component.literal((String)"\n"));
        movesHoverText.append((Component)Component.literal((String)"Move 2: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)moveTwo).withStyle(ChatFormatting.WHITE)));
        movesHoverText.append((Component)Component.literal((String)"\n"));
        movesHoverText.append((Component)Component.literal((String)"Move 3: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)moveThree).withStyle(ChatFormatting.WHITE)));
        movesHoverText.append((Component)Component.literal((String)"\n"));
        movesHoverText.append((Component)Component.literal((String)"Move 4: ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)moveFour).withStyle(ChatFormatting.WHITE)));
        movesText.setStyle(movesText.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)movesHoverText)));
        toSend.append((Component)movesText);
        return (Component)toSend;
    }

    @NotNull
    public final ItemStack pokemonToItem(@NotNull Pokemon pokemon) {
        String string;
        String moveThree;
        String moveTwo;
        String moveOne;
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        if (pokemon.getMoveSet().getMoves().size() >= 1) {
            Move move = pokemon.getMoveSet().get(0);
            Intrinsics.checkNotNull((Object)move);
            v1 = move.getDisplayName().getString();
        } else {
            v1 = moveOne = "Empty";
        }
        if (pokemon.getMoveSet().getMoves().size() >= 2) {
            Move move = pokemon.getMoveSet().get(1);
            Intrinsics.checkNotNull((Object)move);
            v3 = move.getDisplayName().getString();
        } else {
            v3 = moveTwo = "Empty";
        }
        if (pokemon.getMoveSet().getMoves().size() >= 3) {
            Move move = pokemon.getMoveSet().get(2);
            Intrinsics.checkNotNull((Object)move);
            v5 = move.getDisplayName().getString();
        } else {
            v5 = moveThree = "Empty";
        }
        if (pokemon.getMoveSet().getMoves().size() >= 4) {
            Move move = pokemon.getMoveSet().get(3);
            Intrinsics.checkNotNull((Object)move);
            string = move.getDisplayName().getString();
        } else {
            string = "Empty";
        }
        String moveFour = string;
        ItemBuilder itemBuilder = new ItemBuilder(PokemonItem.Companion.from$default((PokemonItem.Companion)PokemonItem.Companion, (Pokemon)pokemon, (int)1, null, (int)4, null)).hideAdditional();
        Component[] componentArray = new Component[17];
        componentArray[0] = Component.literal((String)pokemon.getCaughtBall().item().getDefaultInstance().getDisplayName().getString()).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor(ChatFormatting.DARK_GRAY));
        componentArray[1] = Component.literal((String)"Level: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(pokemon.getLevel())).withStyle(ChatFormatting.WHITE));
        MutableComponent mutableComponent = Component.literal((String)"Nickname: ").withStyle(ChatFormatting.DARK_GREEN);
        Object object = pokemon.getNickname();
        if (object == null || (object = object.getString()) == null) {
            object = "No nickname";
        }
        componentArray[2] = mutableComponent.append((Component)Component.literal((String)object).withStyle(ChatFormatting.WHITE));
        componentArray[3] = Component.literal((String)"Nature: ").withStyle(ChatFormatting.YELLOW).append((Component)LocalizationUtilsKt.lang((String)StringsKt.replace$default((String)pokemon.getNature().getDisplayName(), (String)"cobblemon.", (String)"", (boolean)false, (int)4, null), (Object[])new Object[0]).withStyle(ChatFormatting.WHITE));
        componentArray[4] = Component.literal((String)"Ability: ").withStyle(ChatFormatting.GOLD).append((Component)LocalizationUtilsKt.lang((String)StringsKt.replace$default((String)pokemon.getAbility().getDisplayName(), (String)"cobblemon.", (String)"", (boolean)false, (int)4, null), (Object[])new Object[0]).withStyle(ChatFormatting.WHITE));
        componentArray[5] = Component.literal((String)"IVs: ").withStyle(ChatFormatting.LIGHT_PURPLE);
        componentArray[6] = Component.literal((String)"  HP: ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.HP))).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"  Atk: ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.ATTACK))).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)"  Def: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.DEFENCE))).withStyle(ChatFormatting.WHITE)));
        componentArray[7] = Component.literal((String)"  SpAtk: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_ATTACK))).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"  SpDef: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPECIAL_DEFENCE))).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)"  Spd: ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.valueOf(pokemon.getIvs().getOrDefault((Stat)Stats.SPEED))).withStyle(ChatFormatting.WHITE)));
        componentArray[8] = Component.literal((String)"EVs: ").withStyle(ChatFormatting.DARK_AQUA);
        componentArray[9] = Component.literal((String)"  HP: ").withStyle(ChatFormatting.RED).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.HP))).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"  Atk: ").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.ATTACK))).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)"  Def: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.DEFENCE))).withStyle(ChatFormatting.WHITE)));
        componentArray[10] = Component.literal((String)"  SpAtk: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.SPECIAL_ATTACK))).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"  SpDef: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.SPECIAL_DEFENCE))).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)"  Spd: ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.valueOf(pokemon.getEvs().getOrDefault((Stat)Stats.SPEED))).withStyle(ChatFormatting.WHITE)));
        componentArray[11] = Component.literal((String)"Moves: ").withStyle(ChatFormatting.DARK_GREEN);
        componentArray[12] = Component.literal((String)" ").append((Component)Component.literal((String)moveOne).withStyle(ChatFormatting.WHITE));
        componentArray[13] = Component.literal((String)" ").append((Component)Component.literal((String)moveTwo).withStyle(ChatFormatting.WHITE));
        componentArray[14] = Component.literal((String)" ").append((Component)Component.literal((String)moveThree).withStyle(ChatFormatting.WHITE));
        componentArray[15] = Component.literal((String)" ").append((Component)Component.literal((String)moveFour).withStyle(ChatFormatting.WHITE));
        componentArray[16] = Component.literal((String)"Form: ").withStyle(ChatFormatting.GOLD).append(pokemon.getForm().getName());
        ItemStack itemstack = itemBuilder.addLore(componentArray).setCustomName((Component)(pokemon.getShiny() ? pokemon.getSpecies().getTranslatedName().copy().withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)" \u2605").withStyle(ChatFormatting.GOLD)) : pokemon.getSpecies().getTranslatedName().copy().withStyle(ChatFormatting.GRAY))).build();
        return itemstack;
    }
}

