/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.suppsquared.client;

import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.suppsquared.SuppSquared;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;

public class ClientPackProvider
extends DynClientResourcesGenerator {
    public static final ClientPackProvider INSTANCE = new ClientPackProvider();

    public ClientPackProvider() {
        super(new DynamicTexturePack(SuppSquared.res("generated_pack"), Pack.Position.BOTTOM, true, true));
        ((DynamicTexturePack)this.dynamicPack).addNamespaces(new String[]{"minecraft"});
        ((DynamicTexturePack)this.dynamicPack).addNamespaces(new String[]{"supplementaries"});
    }

    public Logger getLogger() {
        return SuppSquared.LOGGER;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        super.regenerateDynamicAssets(executor);
        executor.accept((manager, sink) -> {
            StaticResource isItemModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.ITEM_MODELS.getPath(SuppSquared.res("item_shelf_birch")));
            StaticResource isBlockState = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCKSTATES.getPath(SuppSquared.res("item_shelf_birch")));
            StaticResource isModel = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_MODELS.getPath(SuppSquared.res("item_shelves/birch")));
            SuppSquared.ITEM_SHELVES.forEach((wood, sign) -> {
                String id = Utils.getID((Block)sign).getPath();
                if (wood == WoodTypeRegistry.OAK_TYPE) {
                    return;
                }
                try {
                    String id2 = id.replace("item_shelf_", "");
                    sink.addSimilarJsonResource(manager, isBlockState, s -> s.replace("item_shelf_birch", id).replace("item_shelves/birch", "item_shelves/" + id2));
                    sink.addSimilarJsonResource(manager, isModel, s -> s.replace("birch", id2));
                    sink.addSimilarJsonResource(manager, isItemModel, s -> s.replace("item_shelf_birch", id).replace("item_shelves/birch", "item_shelves/" + id2));
                }
                catch (Exception ex) {
                    this.getLogger().error("Failed to generate models for {} : {}", sign, (Object)ex);
                }
            });
        });
        executor.accept((manager, sink) -> {
            try (TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"item/item_shelf"));){
                Respriter respriter = Respriter.of((TextureImage)template);
                SuppSquared.ITEM_SHELVES.forEach((wood, sign) -> {
                    ResourceLocation textureRes = SuppSquared.res("item/item_shelves/" + Utils.getID((Block)sign).getPath().replace("item_shelf_", ""));
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    TextureImage newImage = null;
                    Item signItem = wood.getItemOfThis("sign");
                    if (signItem != null) {
                        try (TextureImage vanillaSign2 = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstItemTextureLocation((ResourceManager)manager, (Item)signItem));
                             TextureImage signMask = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"item/hanging_signs/sign_board_mask"));){
                            List targetPalette = Palette.fromAnimatedImage((TextureImage)vanillaSign2, (TextureImage)signMask);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception vanillaSign2) {
                            // empty catch block
                        }
                    }
                    if (newImage == null) {
                        try (TextureImage plankPalette = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                            Palette targetPalette = SpriteUtils.extrapolateWoodItemPalette((TextureImage)plankPalette);
                            newImage = respriter.recolor(targetPalette);
                        }
                        catch (Exception ex) {
                            this.getLogger().error("Failed to generate Sign Post item texture for for {} : {}", sign, (Object)ex);
                        }
                    }
                    if (newImage != null) {
                        sink.addAndCloseTexture(textureRes, newImage);
                    }
                });
            }
            catch (Exception ex) {
                this.getLogger().error("Could not generate any Item Shelves item texture : ", (Throwable)ex);
            }
        });
        executor.accept((manager, sink) -> {
            try (TextureImage template = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"block/item_shelf"));){
                Respriter respriter = Respriter.of((TextureImage)template);
                SuppSquared.ITEM_SHELVES.forEach((wood, sign) -> {
                    ResourceLocation textureRes = SuppSquared.res("block/item_shelves/" + Utils.getID((Block)sign).getPath().replace("item_shelf_", ""));
                    if (sink.alreadyHasTextureAtLocation(manager, textureRes)) {
                        return;
                    }
                    try (TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.planks));){
                        Palette palette = Palette.fromImage((TextureImage)plankTexture);
                        TextureImage newImage = respriter.recolor(palette);
                        sink.addAndCloseTexture(textureRes, newImage);
                    }
                    catch (Exception ex) {
                        this.getLogger().error("Failed to generate Item Shelf block texture for for {} : {}", sign, (Object)ex);
                    }
                });
            }
            catch (Exception ex) {
                this.getLogger().error("Could not generate any Item Shelf block texture : ", (Throwable)ex);
            }
        });
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent lang) {
        SuppSquared.ITEM_SHELVES.forEach((type, block) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)"block.suppsquared.item_shelf", (BlockType)type, (Block)block));
    }

    public void generateSacks(ResourceManager manager, ResourceSink sink) {
        try (TextureImage front_mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/front_mask"));
             TextureImage open_mask = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/open_mask"));
             TextureImage bottom = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"block/sack_bottom"));
             TextureImage closed = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"block/sack_closed"));
             TextureImage open = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"block/sack_open"));
             TextureImage top = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"block/sack_top"));
             TextureImage front = TextureImage.open((ResourceManager)manager, (ResourceLocation)Supplementaries.res((String)"block/sack_front"));){
            Respriter bottom_res = Respriter.of((TextureImage)bottom);
            Respriter closed_res = Respriter.of((TextureImage)closed);
            Respriter open_res = Respriter.masked((TextureImage)open, (TextureImage)open_mask);
            Respriter top_res = Respriter.of((TextureImage)top);
            Respriter front_res = Respriter.masked((TextureImage)front, (TextureImage)front_mask);
            for (DyeColor d : DyeColor.values()) {
                try (TextureImage bottom_c = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/sack_" + d.getName() + "_bottom"));
                     TextureImage closed_c = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/sack_" + d.getName() + "_closed"));
                     TextureImage open_c = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/sack_" + d.getName() + "_open"));
                     TextureImage top_c = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/sack_" + d.getName() + "_top"));
                     TextureImage front_c = TextureImage.open((ResourceManager)manager, (ResourceLocation)SuppSquared.res("block/sack_" + d.getName() + "_front"));){
                    sink.addAndCloseTexture(SuppSquared.res("sack_" + d.getName() + "_bottom"), bottom_res.recolor(Palette.fromImage((TextureImage)bottom_c)));
                    sink.addAndCloseTexture(SuppSquared.res("sack_" + d.getName() + "_closed"), closed_res.recolor(Palette.fromImage((TextureImage)closed_c)));
                    TextureImage i = open_res.recolor(Palette.fromImage((TextureImage)open_c, (TextureImage)open_mask));
                    open_c.crop(open_mask.makeCopy(), false);
                    i.applyOverlay(new TextureImage[]{open_c});
                    sink.addAndCloseTexture(SuppSquared.res("sack_" + d.getName() + "_open"), i);
                    TextureImage f = front_res.recolor(Palette.fromImage((TextureImage)front_c, (TextureImage)front_mask));
                    front_c.crop(front_mask.makeCopy(), false);
                    f.applyOverlay(new TextureImage[]{front_c});
                    sink.addAndCloseTexture(SuppSquared.res("sack_" + d.getName() + "_front"), f);
                    sink.addAndCloseTexture(SuppSquared.res("sack_" + d.getName() + "_top"), top_res.recolor(Palette.fromImage((TextureImage)top_c)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            boolean bl = true;
        }
    }
}

