/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.crops;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.core.block.RopeBlock;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public abstract class ClimbingCropBlock
extends Block {
    public static final BooleanProperty SUPPORTED = BooleanProperty.create((String)"supported");
    protected final VoxelShape shape;

    protected ClimbingCropBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties);
        this.shape = shape;
    }

    protected abstract IntegerProperty getAgeProperty();

    protected abstract int getMaxAge();

    protected abstract ItemLike getRipeItem();

    protected abstract ItemLike getRottenItem();

    protected float getRottenChance() {
        return 0.05f;
    }

    protected int getHarvestResetAge(Level level, BlockPos pos, BlockState state) {
        return 1;
    }

    protected static boolean isRopeAbove(LevelAccessor level, BlockPos pos) {
        BlockPos up = pos.above();
        BlockState s = level.getBlockState(up);
        if (s.getBlock() instanceof RopeBlock) {
            return true;
        }
        return s.isFaceSturdy((BlockGetter)level, up, Direction.DOWN);
    }

    protected static int getHeight(BlockPos pos, LevelAccessor level) {
        int h = 0;
        while (level.getBlockState(pos.below(h)).getBlock() instanceof ClimbingCropBlock) {
            ++h;
        }
        return h;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    public BlockState getStateForAge(int age) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(Math.min(age, this.getMaxAge())))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(false));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        BlockState belowState = level.getBlockState(below);
        return this.mayPlaceOn(belowState) || belowState.getBlock() instanceof ClimbingCropBlock;
    }

    protected boolean mayPlaceOn(BlockState state) {
        return state.getBlock() instanceof FarmBlock;
    }

    protected boolean canGrow(BlockState state) {
        return (Integer)state.getValue((Property)this.getAgeProperty()) < this.getMaxAge();
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        InteractionHand hand = player.getUsedItemHand();
        if (player.getItemInHand(hand).is(Items.BONE_MEAL)) {
            return InteractionResult.PASS;
        }
        int age = (Integer)state.getValue((Property)this.getAgeProperty());
        if (age == this.getMaxAge()) {
            this.dropFruits(level, pos, state);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.is(((Item)ObjectRegistry.ROPE.get()).asItem()) && !((Boolean)state.getValue((Property)SUPPORTED)).booleanValue()) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(true)), 2);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                level.playSound(null, pos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 0.8f, 1.0f);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock() && !level.isClientSide) {
            BlockPos p = pos.above();
            BlockState s = level.getBlockState(p);
            while (s.getBlock() instanceof ClimbingCropBlock) {
                level.destroyBlock(p, true);
                p = p.above();
                s = level.getBlockState(p);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    protected void dropFruits(Level level, BlockPos blockPos, BlockState blockState) {
        int age = (Integer)blockState.getValue((Property)this.getAgeProperty());
        int amount = level.getRandom().nextInt(2) + (age >= this.getMaxAge() ? 1 : 0);
        ItemStack drop = level.getRandom().nextFloat() < this.getRottenChance() ? new ItemStack(this.getRottenItem(), 1) : new ItemStack(this.getRipeItem(), amount);
        ClimbingCropBlock.popResource((Level)level, (BlockPos)blockPos, (ItemStack)drop);
        level.playSound(null, blockPos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
        int resetAge = this.getHarvestResetAge(level, blockPos, blockState);
        level.setBlock(blockPos, (BlockState)blockState.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(resetAge)), 2);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.canGrow(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age;
        if (level.getRawBrightness(pos, 0) >= 9 && (age = ((Integer)state.getValue((Property)this.getAgeProperty())).intValue()) < this.getMaxAge() && random.nextFloat() < 0.2f) {
            boolean supported = (Boolean)state.getValue((Property)SUPPORTED);
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age + 1))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(supported)), 2);
        }
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getAgeProperty(), SUPPORTED});
    }
}

