/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.compat.jei.category;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.satisfy.farm_and_charm.core.recipe.SiloRecipe;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class SiloCategory
implements IRecipeCategory<SiloRecipe> {
    public static final RecipeType<SiloRecipe> DRYING_TYPE = RecipeType.create((String)"farm_and_charm", (String)"drying", SiloRecipe.class);
    private static final int WIDTH = 150;
    private static final int HEIGHT = 50;
    private final IDrawable icon;

    public SiloCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ObjectRegistry.SILO_WOOD.get()));
    }

    @NotNull
    public RecipeType<SiloRecipe> getRecipeType() {
        return DRYING_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"rei.farm_and_charm.silo_category");
    }

    public int getWidth() {
        return 150;
    }

    public int getHeight() {
        return 50;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SiloRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 30, 15).addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 100, 15).addItemStack(recipe.getResultItem(null));
    }
}

