/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.recipe;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.Recipe;
import net.satisfy.farm_and_charm.core.recipe.RecipeUnlockSavedData;

public class RecipeUnlockManager {
    public static void unlockRecipes(ServerPlayer player, List<Recipe<?>> recipes) {
        UUID uuid = player.getUUID();
        Set<ResourceLocation> unlocked = RecipeUnlockManager.loadUnlockedRecipes(player);
        for (Recipe<?> recipe : recipes) {
            unlocked.add(BuiltInRegistries.RECIPE_TYPE.getKey((Object)recipe.getType()));
        }
        RecipeUnlockManager.saveUnlockedRecipes(player, unlocked);
    }

    public static boolean isRecipeLocked(ServerPlayer player, ResourceLocation recipeId) {
        return !RecipeUnlockManager.loadUnlockedRecipes(player).contains(recipeId);
    }

    public static void saveUnlockedRecipes(ServerPlayer player, Set<ResourceLocation> recipes) {
        ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
        RecipeUnlockSavedData data = (RecipeUnlockSavedData)level.getDataStorage().computeIfAbsent(RecipeUnlockSavedData.factory(), "farm_and_charm_recipe_unlock_data");
        data.setPlayerRecipes(player.getUUID(), recipes);
    }

    public static Set<ResourceLocation> loadUnlockedRecipes(ServerPlayer player) {
        ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
        RecipeUnlockSavedData data = (RecipeUnlockSavedData)level.getDataStorage().computeIfAbsent(RecipeUnlockSavedData.factory(), "farm_and_charm_recipe_unlock_data");
        return data.getPlayerRecipes(player.getUUID());
    }
}

