/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.farm_and_charm.FarmAndCharm;
import net.satisfy.farm_and_charm.core.block.entity.ChickenCoopBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.CookingPotBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.CraftingBowlBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.EffectFoodBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.FeedingTroughBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.MincerBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.PetBowlBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.RoasterBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.RopeKnotBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.ScarecrowBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.SiloBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.StorageBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.StoveBlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.WaterSprinklerBlockEntity;
import net.satisfy.farm_and_charm.core.entity.ChairEntity;
import net.satisfy.farm_and_charm.core.entity.PlowCartEntity;
import net.satisfy.farm_and_charm.core.entity.RottenTomatoEntity;
import net.satisfy.farm_and_charm.core.entity.SupplyCartEntity;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.registry.StorageTypeRegistry;

public class EntityTypeRegistry {
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.BLOCK_ENTITY_TYPE).getRegistrar();
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.of(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).build(null));
    public static final RegistrySupplier<BlockEntityType<RoasterBlockEntity>> ROASTER_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("roaster", () -> BlockEntityType.Builder.of(RoasterBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.ROASTER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CraftingBowlBlockEntity>> CRAFTING_BOWL_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("crafting_bowl", () -> BlockEntityType.Builder.of(CraftingBowlBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CRAFTING_BOWL.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CookingPotBlockEntity>> COOKING_POT_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cooking_pot", () -> BlockEntityType.Builder.of(CookingPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.COOKING_POT.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<StoveBlockEntity>> STOVE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("stove_block", () -> BlockEntityType.Builder.of(StoveBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.STOVE.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<WaterSprinklerBlockEntity>> SPRINKLER_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("water_sprinkler", () -> BlockEntityType.Builder.of(WaterSprinklerBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.WATER_SPRINKLER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<SiloBlockEntity>> SILO_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("silo", () -> BlockEntityType.Builder.of(SiloBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SILO_WOOD.get(), (Block)ObjectRegistry.SILO_COPPER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<FeedingTroughBlockEntity>> FEEDING_TROUGH_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("feeding_trough", () -> BlockEntityType.Builder.of(FeedingTroughBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FEEDING_TROUGH.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<ScarecrowBlockEntity>> SCARECROW_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("scarecrow", () -> BlockEntityType.Builder.of(ScarecrowBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SCARECROW.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<MincerBlockEntity>> MINCER_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("mincer", () -> BlockEntityType.Builder.of(MincerBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.MINCER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<EffectFoodBlockEntity>> EFFECT_FOOD_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("effect_food_block", () -> BlockEntityType.Builder.of(EffectFoodBlockEntity::new, (Block[])new Block[0]).build(null));
    public static final RegistrySupplier<BlockEntityType<PetBowlBlockEntity>> PET_BOWL_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("pet_bowl", () -> BlockEntityType.Builder.of(PetBowlBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.PET_BOWL.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<ChickenCoopBlockEntity>> CHICKEN_COOP_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("chicken_coop", () -> BlockEntityType.Builder.of(ChickenCoopBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.CHICKEN_COOP.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<RopeKnotBlockEntity>> ROPE_KNOT_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("rope_knot", () -> BlockEntityType.Builder.of(RopeKnotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.ROPE_KNOT.get()}).build(null));
    public static final RegistrySupplier<EntityType<RottenTomatoEntity>> ROTTEN_TOMATO = EntityTypeRegistry.registerEntityType("rotten_tomato", () -> EntityType.Builder.of(RottenTomatoEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(FarmAndCharm.identifier("rotten_tomato").toString()));
    public static final RegistrySupplier<EntityType<SupplyCartEntity>> SUPPLY_CART = EntityTypeRegistry.registerEntityType("cart", () -> EntityType.Builder.of(SupplyCartEntity::new, (MobCategory)MobCategory.MISC).sized(1.875f, 0.875f).clientTrackingRange(10).build(FarmAndCharm.identifier("supply_cart").toString()));
    public static final RegistrySupplier<EntityType<PlowCartEntity>> PLOW = EntityTypeRegistry.registerEntityType("plow", () -> EntityType.Builder.of(PlowCartEntity::new, (MobCategory)MobCategory.MISC).sized(1.875f, 0.875f).clientTrackingRange(10).build(FarmAndCharm.identifier("plow").toString()));
    public static final RegistrySupplier<EntityType<ChairEntity>> CHAIR = EntityTypeRegistry.registerEntityType("chair", () -> EntityType.Builder.of(ChairEntity::new, (MobCategory)MobCategory.MISC).sized(0.001f, 0.001f).build(FarmAndCharm.identifier("chair").toString()));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(FarmAndCharm.identifier(path), type);
    }

    private static <T extends EntityType<?>> RegistrySupplier<T> registerEntityType(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(FarmAndCharm.identifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
    }
}

