/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.particles.gooexplodeparticle;

import com.direwolf20.justdirethings.client.particles.gooexplodeparticle.GooExplodeParticleData;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class GooExplodeParticle
extends BreakingItemParticle {
    Random random = new Random();
    private float partSize;
    public static ParticleProvider<GooExplodeParticleData> FACTORY = (data, world, x, y, z, xSpeed, ySpeed, zSpeed) -> new GooExplodeParticle(world, x, y, z, data.getItemStack());

    public GooExplodeParticle(ClientLevel world, double x, double y, double z, ItemStack itemStack) {
        super(world, x, y, z, itemStack);
        float minSize = 0.25f;
        float maxSize = 0.5f;
        this.partSize = minSize + this.random.nextFloat() * (maxSize - minSize);
        this.lifetime = 30;
        int longLifeChance = this.random.nextInt(20);
        if (longLifeChance == 0) {
            this.lifetime = 120;
        }
        this.scale(this.partSize);
        this.partSize = this.quadSize;
        if (this.sprite == null) {
            this.setSprite(Minecraft.getInstance().getItemRenderer().getModel(new ItemStack((ItemLike)Blocks.COBBLESTONE), (Level)world, (LivingEntity)null, 0).getParticleIcon());
        }
    }

    public void tick() {
        super.tick();
        this.updateColorAndGravity();
    }

    public void updateColorAndGravity() {
        float relativeAge = (float)(this.lifetime - this.age) / (float)this.lifetime;
        if (relativeAge < 0.5f) {
            float adjustedAge = (float)Math.pow(relativeAge / 0.5f, 2.0);
            this.alpha = Mth.lerp((float)adjustedAge, (float)0.25f, (float)1.0f);
        }
    }

    protected int getLightColor(float pPartialTick) {
        return 0xF00080;
    }
}

