/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.items.interfaces;

import com.direwolf20.justdirethings.client.renderactions.ThingFinder;
import com.direwolf20.justdirethings.common.blockentities.EclipseGateBE;
import com.direwolf20.justdirethings.common.blocks.EclipseGateBlock;
import com.direwolf20.justdirethings.common.entities.DecoyEntity;
import com.direwolf20.justdirethings.common.events.BlockEvents;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.FluidContainingItem;
import com.direwolf20.justdirethings.common.items.interfaces.Helpers;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.common.items.tools.utils.GooTier;
import com.direwolf20.justdirethings.common.network.data.ClientSoundPayload;
import com.direwolf20.justdirethings.datagen.JustDireBlockTags;
import com.direwolf20.justdirethings.datagen.JustDireEntityTags;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MiscTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class AbilityMethods {
    public static boolean glowing(Level level, Player player, ItemStack itemStack) {
        if (Helpers.testUseTool(itemStack, Ability.GLOWING) < 0) {
            return false;
        }
        BlockPos playerPos = player.getOnPos();
        int radius = 20;
        AABB searchArea = new AABB(playerPos).inflate((double)radius, (double)radius, (double)radius);
        List entityList = level.getEntitiesOfClass(Mob.class, searchArea, entity -> true).stream().toList();
        for (Mob entity2 : entityList) {
            entity2.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0));
        }
        player.playNotifySound(SoundEvents.SCULK_CLICKING, SoundSource.PLAYERS, 1.0f, 1.0f);
        Helpers.damageTool(itemStack, (LivingEntity)player, Ability.GLOWING);
        return true;
    }

    public static boolean scanForMobScanner(Level level, Player player, ItemStack itemStack) {
        if (Helpers.testUseTool(itemStack, Ability.MOBSCANNER) < 0) {
            return false;
        }
        return AbilityMethods.scanFor(level, player, itemStack, Ability.MOBSCANNER);
    }

    public static boolean scanForOreScanner(Level level, Player player, ItemStack itemStack) {
        if (Helpers.testUseTool(itemStack, Ability.ORESCANNER) < 0) {
            return false;
        }
        return AbilityMethods.scanFor(level, player, itemStack, Ability.ORESCANNER);
    }

    public static boolean scanForOreXRAY(Level level, Player player, ItemStack itemStack) {
        if (Helpers.testUseTool(itemStack, Ability.OREXRAY) < 0) {
            return false;
        }
        return AbilityMethods.scanFor(level, player, itemStack, Ability.OREXRAY);
    }

    public static boolean scanFor(Level level, Player player, ItemStack itemStack, Ability toolAbility) {
        if (level.isClientSide) {
            ThingFinder.discover(player, toolAbility, itemStack);
            if (toolAbility.equals((Object)Ability.OREXRAY)) {
                player.playNotifySound(SoundEvents.SCULK_CLICKING, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                player.playNotifySound(SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            Helpers.damageTool(itemStack, (LivingEntity)player, toolAbility);
        }
        return false;
    }

    public static boolean leafbreaker(UseOnContext pContext) {
        ItemStack pStack = pContext.getItemInHand();
        if (Helpers.testUseTool(pStack, Ability.LEAFBREAKER) < 0) {
            return false;
        }
        Level pLevel = pContext.getLevel();
        BlockPos pPos = pContext.getClickedPos();
        BlockState pState = pLevel.getBlockState(pPos);
        Player pEntityLiving = pContext.getPlayer();
        if (pState.getTags().anyMatch(tag -> tag.equals((Object)BlockTags.LEAVES))) {
            int maxBreak = 64;
            Item item = pStack.getItem();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                if (tieredItem.getTier().equals((Object)GooTier.BLAZEGOLD)) {
                    maxBreak = 128;
                } else if (tieredItem.getTier().equals((Object)GooTier.CELESTIGEM)) {
                    maxBreak = 192;
                } else if (tieredItem.getTier().equals((Object)GooTier.ECLIPSEALLOY)) {
                    maxBreak = 256;
                }
            }
            Set<BlockPos> alsoBreakSet = Helpers.findLikeBlocks(pLevel, pState, pPos, maxBreak, 2);
            BlockEvents.alreadyBreaking = true;
            BlockEvents.spawnDropsAtPos = pPos;
            for (BlockPos breakPos : alsoBreakSet) {
                if (Helpers.testUseTool(pStack, Ability.LEAFBREAKER) < 0) break;
                Helpers.breakBlocksNew(pLevel, breakPos, (LivingEntity)pEntityLiving, pStack, false, false);
                pLevel.sendBlockUpdated(breakPos, pState, pLevel.getBlockState(breakPos), 3);
                if (!(Math.random() < 0.1)) continue;
                Helpers.damageTool(pStack, (LivingEntity)pEntityLiving, Ability.LEAFBREAKER);
            }
            BlockEvents.alreadyBreaking = false;
            BlockEvents.spawnDropsAtPos = BlockPos.ZERO;
            return true;
        }
        return false;
    }

    public static boolean eclipseGate(UseOnContext pContext) {
        ItemStack pStack = pContext.getItemInHand();
        Level level = pContext.getLevel();
        if (level.isClientSide) {
            return true;
        }
        int distance = ToggleableTool.getToolValue(pStack, Ability.ECLIPSEGATE.getName());
        Set<BlockPos> posList = AbilityMethods.getEclipseGateBlocks(pContext, distance);
        boolean anyWorked = false;
        for (BlockPos blockPos : posList) {
            if (Helpers.testUseTool(pStack, Ability.ECLIPSEGATE) < 0) break;
            BlockState blockState = level.getBlockState(blockPos);
            boolean placed = level.setBlockAndUpdate(blockPos, ((EclipseGateBlock)((Object)Registration.EclipseGateBlock.get())).defaultBlockState());
            if (!placed) continue;
            level.sendBlockUpdated(blockPos, blockState, ((EclipseGateBlock)((Object)Registration.EclipseGateBlock.get())).defaultBlockState(), 3);
            BlockEntity be = level.getBlockEntity(blockPos);
            if (be instanceof EclipseGateBE) {
                EclipseGateBE eclipseGateBE = (EclipseGateBE)be;
                eclipseGateBE.setSourceBlock(blockState);
            }
            Helpers.damageTool(pStack, (LivingEntity)pContext.getPlayer(), Ability.ECLIPSEGATE);
            anyWorked = true;
        }
        if (anyWorked) {
            level.playSound(null, pContext.getClickedPos(), SoundEvents.ENDER_EYE_DEATH, SoundSource.PLAYERS, 1.0f, 1.0f);
            ToggleableTool.teleportParticles((ServerLevel)level, posList);
            return true;
        }
        return false;
    }

    public static Set<BlockPos> getEclipseGateBlocks(UseOnContext pContext, int distance) {
        BlockPos clickedPos = pContext.getClickedPos();
        Direction direction = pContext.getClickedFace().getOpposite();
        BlockPos startPos = clickedPos.offset(direction.getAxis() == Direction.Axis.X ? 0 : -1, direction.getAxis() == Direction.Axis.Y ? 0 : -1, direction.getAxis() == Direction.Axis.Z ? 0 : -1);
        BlockPos endPos = clickedPos.relative(direction, distance - 1).offset(direction.getAxis() == Direction.Axis.X ? 0 : 1, direction.getAxis() == Direction.Axis.Y ? 0 : 1, direction.getAxis() == Direction.Axis.Z ? 0 : 1);
        Set<BlockPos> posSet = BlockPos.betweenClosedStream((BlockPos)startPos, (BlockPos)endPos).filter(blockPos -> AbilityMethods.isValidGateBlock((ServerLevel)pContext.getLevel(), blockPos, pContext.getPlayer())).map(BlockPos::immutable).collect(Collectors.toSet());
        return posSet;
    }

    public static boolean isValidGateBlock(ServerLevel serverLevel, BlockPos blockPos, Player player) {
        if (serverLevel.getBlockEntity(blockPos) != null) {
            return false;
        }
        BlockState blockState = serverLevel.getBlockState(blockPos);
        if (blockState.is((Block)Registration.EclipseGateBlock.get())) {
            return false;
        }
        if (blockState.isAir()) {
            return false;
        }
        if (blockState.getDestroySpeed((BlockGetter)serverLevel, blockPos) < 0.0f) {
            return false;
        }
        if (blockState.is(JustDireBlockTags.ECLISEGATEDENY)) {
            return false;
        }
        return !blockState.is(Tags.Blocks.RELOCATION_NOT_SUPPORTED);
    }

    public static boolean voidShift(Level level, Player player, ItemStack itemStack) {
        if (level.isClientSide) {
            return false;
        }
        Vec3 shiftPosition = AbilityMethods.getShiftPosition(level, player, itemStack);
        if (!shiftPosition.equals((Object)Vec3.ZERO)) {
            WorldBorder worldBorder = level.getWorldBorder();
            if (!worldBorder.isWithinBounds(shiftPosition)) {
                return false;
            }
            int distanceTraveled = (int)player.position().distanceTo(shiftPosition);
            if (Helpers.testUseTool(itemStack, Ability.VOIDSHIFT, distanceTraveled) < 0) {
                return false;
            }
            if (player.isPassenger()) {
                player.dismountTo(shiftPosition.x, shiftPosition.y, shiftPosition.z);
            } else {
                player.teleportTo(shiftPosition.x, shiftPosition.y, shiftPosition.z);
            }
            player.resetFallDistance();
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientSoundPayload(SoundEvents.PLAYER_TELEPORT.getLocation(), 1.0f, 1.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
            level.playSound(player, BlockPos.containing((Position)shiftPosition), SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
            Helpers.damageTool(itemStack, (LivingEntity)player, Ability.VOIDSHIFT, distanceTraveled);
        }
        return false;
    }

    public static Vec3 getShiftPosition(Level level, Player player, ItemStack itemStack) {
        int distance = ToggleableTool.getToolValue(itemStack, Ability.VOIDSHIFT.getName());
        BlockHitResult result = (BlockHitResult)player.pick((double)distance, 0.0f, false);
        Vec3 returnVec = result.getType().equals((Object)HitResult.Type.MISS) ? AbilityMethods.getShapeAdjustedPosition(level, player, result, result.getDirection().getOpposite()) : AbilityMethods.getShapeAdjustedPosition(level, player, result);
        return returnVec;
    }

    public static Vec3 getShapeAdjustedPosition(Level level, Player player, BlockHitResult result) {
        BlockPos landingPos = result.getBlockPos().below().relative(result.getDirection());
        BlockState blockState = level.getBlockState(landingPos);
        VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)level, landingPos, CollisionContext.of((Entity)player));
        if (voxelShape.isEmpty()) {
            return Vec3.atBottomCenterOf((Vec3i)landingPos);
        }
        return Vec3.atBottomCenterOf((Vec3i)landingPos).add(0.0, voxelShape.max(Direction.Axis.Y), 0.0);
    }

    public static Vec3 getShapeAdjustedPosition(Level level, Player player, BlockHitResult result, Direction dir) {
        BlockPos landingPos = result.getBlockPos().below().relative(result.getDirection()).relative(dir);
        BlockState blockState = level.getBlockState(landingPos);
        VoxelShape voxelShape = blockState.getCollisionShape((BlockGetter)level, landingPos, CollisionContext.of((Entity)player));
        if (voxelShape.isEmpty()) {
            return Vec3.atBottomCenterOf((Vec3i)landingPos);
        }
        return Vec3.atBottomCenterOf((Vec3i)landingPos).add(0.0, voxelShape.max(Direction.Axis.Y), 0.0);
    }

    public static boolean airBurst(Level level, Player player, ItemStack itemStack) {
        int multiplier = ToggleableTool.getToolValue(itemStack, Ability.AIRBURST.getName());
        if (Helpers.testUseTool(itemStack, Ability.AIRBURST, multiplier) < 0) {
            return false;
        }
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Vec3 lookDirection = player.getViewVector(1.0f);
            double addedStrength = (double)multiplier / 2.0;
            double burstStrength = 1.5 + addedStrength;
            player.setDeltaMovement(lookDirection.x * burstStrength, lookDirection.y * burstStrength, lookDirection.z * burstStrength);
            serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
            player.resetFallDistance();
            Helpers.damageTool(itemStack, (LivingEntity)player, Ability.AIRBURST, multiplier);
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientSoundPayload(SoundEvents.FIRECHARGE_USE.getLocation(), 0.5f, 0.125f), (CustomPacketPayload[])new CustomPacketPayload[0]);
            level.playSound(player, player.getOnPos(), SoundEvents.FIRECHARGE_USE, SoundSource.PLAYERS, 0.5f, 0.125f);
            return true;
        }
        return true;
    }

    public static boolean cauterizeWounds(Level level, Player player, ItemStack itemStack) {
        if (Helpers.testUseTool(itemStack, Ability.CAUTERIZEWOUNDS) < 0) {
            return false;
        }
        if (player.getHealth() >= player.getMaxHealth()) {
            return false;
        }
        if (!level.isClientSide) {
            ToggleableTool toggleableTool;
            int currentCooldown = ToggleableTool.getAnyCooldown(itemStack, Ability.CAUTERIZEWOUNDS);
            if (currentCooldown != -1) {
                return false;
            }
            Item item = itemStack.getItem();
            if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.CAUTERIZEWOUNDS)) {
                AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.CAUTERIZEWOUNDS);
                ToggleableTool.addCooldown(itemStack, Ability.CAUTERIZEWOUNDS, abilityParams.cooldown, false);
                player.heal(6.0f);
                player.playNotifySound(SoundEvents.LAVA_EXTINGUISH, SoundSource.PLAYERS, 1.0f, 1.0f);
                Random random = new Random();
                Vec3 pos = player.getEyePosition();
                for (int i = 0; i < 10; ++i) {
                    double d0 = pos.x() + random.nextDouble();
                    double d1 = pos.y() + random.nextDouble();
                    double d2 = pos.z() + random.nextDouble();
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                }
                Helpers.damageTool(itemStack, (LivingEntity)player, Ability.CAUTERIZEWOUNDS);
                return true;
            }
        }
        return false;
    }

    public static boolean lawnmower(Level level, Player player, ItemStack itemStack) {
        if (!level.isClientSide) {
            ArrayList<TagKey<Block>> tags = new ArrayList<TagKey<Block>>();
            tags.add(JustDireBlockTags.LAWNMOWERABLE);
            Set<BlockPos> breakBlocks = Helpers.findTaggedBlocks(level, tags, player.getOnPos(), 64, 5);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            for (BlockPos breakPos : breakBlocks) {
                if (Helpers.testUseTool(itemStack, Ability.LAWNMOWER) < 0) break;
                BlockState state = level.getBlockState(breakPos);
                BlockEntity blockEntity = level.getBlockEntity(breakPos);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    boolean removed = level.destroyBlock(breakPos, false);
                    if (removed) {
                        drops.addAll(Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)breakPos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)itemStack));
                    }
                }
                if (!(Math.random() < 0.1)) continue;
                Helpers.damageTool(itemStack, (LivingEntity)player, Ability.LAWNMOWER);
            }
            if (!breakBlocks.isEmpty()) {
                BlockPos firstPos = breakBlocks.iterator().next();
                AbilityMethods.handleDrops(itemStack, (ServerLevel)level, firstPos, (LivingEntity)player, breakBlocks, drops, level.getBlockState(firstPos), 0);
            }
            return true;
        }
        return false;
    }

    public static void handleDrops(ItemStack pStack, ServerLevel serverLevel, BlockPos pPos, LivingEntity pEntityLiving, BlockPos breakBlockPosition, List<ItemStack> drops, BlockState pState, int totalExp) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        positions.add(breakBlockPosition);
        AbilityMethods.handleDrops(pStack, serverLevel, pPos, pEntityLiving, positions, drops, pState, totalExp);
    }

    public static void handleDrops(ItemStack pStack, ServerLevel serverLevel, BlockPos pPos, LivingEntity pEntityLiving, Set<BlockPos> breakBlockPositions, List<ItemStack> drops, BlockState pState, int totalExp) {
        Item item = pStack.getItem();
        if (item instanceof ToggleableTool) {
            IItemHandler handler;
            ToggleableTool toggleableTool = (ToggleableTool)item;
            if (toggleableTool.canUseAbility(pStack, Ability.SMELTER) && pStack.getDamageValue() < pStack.getMaxDamage()) {
                boolean[] smeltedItemsFlag = new boolean[1];
                drops = Helpers.smeltDrops(serverLevel, drops, pStack, pEntityLiving, smeltedItemsFlag);
                if (smeltedItemsFlag[0]) {
                    ToggleableTool.smelterParticles(serverLevel, breakBlockPositions);
                }
            }
            if (!drops.isEmpty() && toggleableTool.canUseAbility(pStack, Ability.DROPTELEPORT) && (handler = ToggleableTool.getBoundHandler(serverLevel, pStack)) != null && pEntityLiving instanceof Player) {
                Player player = (Player)pEntityLiving;
                Helpers.teleportDrops(drops, handler, pStack, player);
                if (drops.isEmpty()) {
                    ToggleableTool.teleportParticles(serverLevel, breakBlockPositions);
                }
            }
            if (!drops.isEmpty()) {
                Helpers.dropDrops(drops, serverLevel, pPos);
            }
            if (totalExp > 0) {
                pState.getBlock().popExperience(serverLevel, pPos, totalExp);
            }
        }
    }

    public static boolean runSpeed(Level level, Player player, ItemStack itemStack) {
        if (player.isSprinting() && !player.isFallFlying() && player.zza > 0.0f && !player.isInWaterOrBubble()) {
            float speed = (float)ToggleableTool.getToolValue(itemStack, Ability.RUNSPEED.getName()) / 25.0f;
            if (!player.onGround()) {
                speed /= 4.0f;
            }
            player.moveRelative(speed, new Vec3(0.0, 0.0, 1.0));
        }
        return false;
    }

    public static boolean walkSpeed(Level level, Player player, ItemStack itemStack) {
        boolean shouldBoostFlight;
        ToggleableTool toggleableTool;
        ItemStack chestItem = player.getItemBySlot(EquipmentSlot.CHEST);
        Item item = chestItem.getItem();
        boolean canBoostElytra = item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.ELYTRA);
        boolean isNotFlying = player.fallDistance <= 0.0f && !player.isFallFlying();
        boolean bl = shouldBoostFlight = canBoostElytra || isNotFlying;
        if (!player.isSprinting() && shouldBoostFlight && player.zza > 0.0f && !player.isInWaterOrBubble()) {
            float speed = (float)ToggleableTool.getToolValue(itemStack, Ability.WALKSPEED.getName()) / 25.0f;
            if (!player.onGround()) {
                speed /= 4.0f;
            }
            player.moveRelative(speed, new Vec3(0.0, 0.0, 1.0));
        }
        return false;
    }

    public static boolean swimSpeed(Level level, Player player, ItemStack itemStack) {
        if (player.fallDistance <= 0.0f && !player.isFallFlying() && player.zza > 0.0f && player.isInWaterOrBubble()) {
            float speed = (float)ToggleableTool.getToolValue(itemStack, Ability.SWIMSPEED.getName()) / 50.0f;
            player.moveRelative(speed, new Vec3(0.0, 0.0, 1.0));
        }
        return false;
    }

    public static boolean waterBreathing(Level level, Player player, ItemStack itemStack) {
        if (player.isInWater() && (double)player.getAirSupply() < 0.5 * (double)player.getMaxAirSupply()) {
            player.setAirSupply(player.getMaxAirSupply());
            Helpers.damageTool(itemStack, (LivingEntity)player, Ability.WATERBREATHING);
            player.playNotifySound(SoundEvents.PLAYER_BREATH, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
        return false;
    }

    public static boolean jumpBoost(Level level, Player player, ItemStack itemStack) {
        if (!player.isInWaterOrBubble() && !player.isFallFlying()) {
            float speed = (float)ToggleableTool.getToolValue(itemStack, Ability.JUMPBOOST.getName()) / 7.5f;
            player.moveRelative(speed, new Vec3(0.0, 1.0, 0.0));
        }
        return false;
    }

    public static boolean extinguish(Level level, Player player, ItemStack itemStack) {
        if (level.isClientSide) {
            return false;
        }
        if (player.isOnFire() && ((ServerPlayer)player).gameMode.isSurvival()) {
            ToggleableTool toggleableTool;
            int currentCooldown = ToggleableTool.getAnyCooldown(itemStack, Ability.EXTINGUISH);
            if (currentCooldown != -1) {
                return false;
            }
            Item item = itemStack.getItem();
            if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.EXTINGUISH)) {
                AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.EXTINGUISH);
                ToggleableTool.addCooldown(itemStack, Ability.EXTINGUISH, abilityParams.cooldown, false);
                player.clearFire();
                player.playNotifySound(SoundEvents.LAVA_EXTINGUISH, SoundSource.PLAYERS, 0.5f, 1.0f);
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, player.getX(), player.getY(), player.getZ(), 20, 0.5, 1.5, 0.5, 0.0);
                Helpers.damageTool(itemStack, (LivingEntity)player, Ability.EXTINGUISH);
            }
        }
        return false;
    }

    public static boolean invulnerability(Level level, Player player, ItemStack itemStack) {
        ToggleableTool toggleableTool;
        if (level.isClientSide) {
            return false;
        }
        int currentCooldown = ToggleableTool.getAnyCooldown(itemStack, Ability.INVULNERABILITY);
        if (currentCooldown != -1) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.INVULNERABILITY)) {
            AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.INVULNERABILITY);
            ToggleableTool.addCooldown(itemStack, Ability.INVULNERABILITY, abilityParams.activeCooldown, true);
            player.playNotifySound(SoundEvents.CONDUIT_ACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
            Helpers.damageTool(itemStack, (LivingEntity)player, Ability.INVULNERABILITY);
        }
        return false;
    }

    public static boolean stupefy(Level level, Player player, ItemStack itemStack) {
        Entity entity;
        ToggleableTool toggleableTool;
        if (level.isClientSide) {
            return false;
        }
        int currentCooldown = ToggleableTool.getAnyCooldown(itemStack, Ability.STUPEFY);
        if (currentCooldown != -1) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.STUPEFY) && (entity = MiscTools.getEntityLookedAt(player, 32.0)) instanceof Mob) {
            Mob mob = (Mob)entity;
            AbilityMethods.addStupefyTarget(itemStack, entity.getStringUUID());
            mob.setTarget(null);
            AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.STUPEFY);
            ToggleableTool.addCooldown(itemStack, Ability.STUPEFY, abilityParams.activeCooldown, true);
            player.playNotifySound(SoundEvents.ILLUSIONER_CAST_SPELL, SoundSource.PLAYERS, 0.5f, 0.75f);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WHITE_SMOKE, mob.getX(), mob.getEyeY(), mob.getZ(), 20, 0.25, 0.2, 0.25, 0.0);
            Helpers.damageTool(itemStack, (LivingEntity)player, Ability.STUPEFY);
        }
        return false;
    }

    public static boolean polymorphRandom(Level level, Player player, ItemStack itemStack) {
        ToggleableTool toggleableTool;
        if (level.isClientSide) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.POLYMORPH_RANDOM)) {
            int fuelAmt = (Integer)Config.RANDOM_POLYMORPH_COST.get();
            if (!FluidContainingItem.hasEnoughFluid(itemStack, fuelAmt)) {
                return false;
            }
            Entity entity = MiscTools.getEntityLookedAt(player, 4.0);
            if (entity == null) {
                return false;
            }
            boolean peaceful = entity.getType().is(JustDireEntityTags.POLYMORPHIC_PEACEFUL);
            if (!peaceful && !entity.getType().is(JustDireEntityTags.POLYMORPHIC_HOSTILE)) {
                player.displayClientMessage((Component)Component.translatable((String)"justdirethings.invalidpolymorphentity"), true);
                return false;
            }
            if (entity instanceof Mob) {
                Mob newMob;
                Mob mob = (Mob)entity;
                EntityType<?> newType = AbilityMethods.getRandomMobTypeByCategory(level, peaceful);
                if (newType != null && (newMob = (Mob)newType.create(level)) != null) {
                    EventHooks.finalizeMobSpawn((Mob)newMob, (ServerLevelAccessor)((ServerLevel)level), (DifficultyInstance)level.getCurrentDifficultyAt(player.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null);
                    newMob.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                    newMob.setHealth(newMob.getMaxHealth());
                    ((ServerLevel)level).addFreshEntityWithPassengers((Entity)newMob);
                    if (!newMob.isAddedToLevel()) {
                        return false;
                    }
                    player.playNotifySound(SoundEvents.ILLUSIONER_CAST_SPELL, SoundSource.PLAYERS, 0.5f, 0.75f);
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WHITE_SMOKE, mob.getX(), mob.getEyeY(), mob.getZ(), 20, 0.25, 0.2, 0.25, 0.0);
                    mob.discard();
                    FluidContainingItem.consumeFluid(itemStack, fuelAmt);
                    Helpers.damageTool(itemStack, (LivingEntity)player, Ability.POLYMORPH_RANDOM);
                }
            }
        }
        return false;
    }

    public static boolean polymorphTarget(Level level, Player player, ItemStack itemStack) {
        ToggleableTool toggleableTool;
        if (level.isClientSide) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.POLYMORPH_TARGET)) {
            Entity entity = MiscTools.getEntityLookedAt(player, 4.0);
            if (entity == null) {
                return false;
            }
            int fuelAmt = (Integer)Config.TARGET_POLYMORPH_COST.get();
            if (!FluidContainingItem.hasEnoughFluid(itemStack, fuelAmt)) {
                return false;
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (!itemStack.has(JustDireDataComponents.ENTITIYTYPE)) {
                    return false;
                }
                EntityType newType = EntityType.byString((String)((String)itemStack.get(JustDireDataComponents.ENTITIYTYPE))).orElse(null);
                if (newType == null) {
                    return false;
                }
                Mob newMob = (Mob)newType.create(level);
                if (newMob != null) {
                    EventHooks.finalizeMobSpawn((Mob)newMob, (ServerLevelAccessor)((ServerLevel)level), (DifficultyInstance)level.getCurrentDifficultyAt(player.blockPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null);
                    newMob.moveTo(mob.getX(), mob.getY(), mob.getZ(), mob.getYRot(), mob.getXRot());
                    newMob.setHealth(newMob.getMaxHealth());
                    ((ServerLevel)level).addFreshEntity((Entity)newMob);
                    if (!newMob.isAddedToLevel()) {
                        return false;
                    }
                    player.playNotifySound(SoundEvents.ILLUSIONER_CAST_SPELL, SoundSource.PLAYERS, 0.5f, 0.75f);
                    ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.WHITE_SMOKE, mob.getX(), mob.getEyeY(), mob.getZ(), 20, 0.25, 0.2, 0.25, 0.0);
                    mob.discard();
                    FluidContainingItem.consumeFluid(itemStack, fuelAmt);
                    Helpers.damageTool(itemStack, (LivingEntity)player, Ability.POLYMORPH_RANDOM);
                }
            }
        }
        return false;
    }

    public static boolean groundstomp(Level level, Player player, ItemStack itemStack) {
        ToggleableTool toggleableTool;
        if (level.isClientSide) {
            return false;
        }
        int currentCooldown = ToggleableTool.getAnyCooldown(itemStack, Ability.GROUNDSTOMP);
        if (currentCooldown != -1) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.GROUNDSTOMP)) {
            AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.GROUNDSTOMP);
            ToggleableTool.addCooldown(itemStack, Ability.GROUNDSTOMP, abilityParams.cooldown, false);
            int radius = 3;
            AABB aabb = new AABB(player.getX() - (double)radius, player.getY() - (double)radius, player.getZ() - (double)radius, player.getX() + (double)radius, player.getY() + (double)radius, player.getZ() + (double)radius);
            ArrayList stompList = new ArrayList(level.getEntitiesOfClass(Mob.class, aabb, AbilityMethods::isValidStompEntity));
            double strength = ToggleableTool.getToolValue(itemStack, Ability.GROUNDSTOMP.getName());
            for (Mob mob : stompList) {
                double dz;
                double dx = mob.getX() - player.getX();
                double distance = Math.sqrt(dx * dx + (dz = mob.getZ() - player.getZ()) * dz);
                if (distance == 0.0) continue;
                mob.knockback(strength, -(dx /= distance), -(dz /= distance));
            }
            player.playNotifySound(SoundEvents.MACE_SMASH_GROUND, SoundSource.PLAYERS, 0.5f, 1.0f);
            ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.DUST_PLUME, player.getX(), player.getY(), player.getZ(), 20, 0.5, 0.2, 0.5, 0.0);
            Helpers.damageTool(itemStack, (LivingEntity)player, Ability.GROUNDSTOMP);
        }
        return false;
    }

    public static boolean decoy(Level level, Player player, ItemStack itemStack) {
        ToggleableTool toggleableTool;
        if (level.isClientSide) {
            return false;
        }
        int currentCooldown = ToggleableTool.getAnyCooldown(itemStack, Ability.DECOY);
        if (currentCooldown != -1) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.DECOY)) {
            AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.DECOY);
            DecoyEntity decoy = new DecoyEntity(level);
            decoy.setPos(player.position());
            decoy.setSummonerName(player.getName().getString());
            decoy.setOwnerUUID(player.getUUID());
            level.addFreshEntity((Entity)decoy);
            ToggleableTool.addCooldown(itemStack, Ability.DECOY, abilityParams.activeCooldown, true);
            player.playNotifySound(SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.PLAYERS, 1.0f, 1.0f);
            Helpers.damageTool(itemStack, (LivingEntity)player, Ability.DECOY);
        }
        return false;
    }

    public static boolean debuffRemover(Level level, Player player, ItemStack itemStack) {
        ToggleableTool toggleableTool;
        if (level.isClientSide) {
            return false;
        }
        int currentCooldown = ToggleableTool.getAnyCooldown(itemStack, Ability.DEBUFFREMOVER);
        if (currentCooldown != -1) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.DEBUFFREMOVER)) {
            AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.DEBUFFREMOVER);
            ToggleableTool.addCooldown(itemStack, Ability.DEBUFFREMOVER, abilityParams.cooldown, false);
            player.playNotifySound(SoundEvents.WANDERING_TRADER_DRINK_MILK, SoundSource.PLAYERS, 1.0f, 1.0f);
            ArrayList<Holder> negativeEffects = new ArrayList<Holder>();
            for (Holder mobEffect : player.getActiveEffectsMap().keySet()) {
                if (((MobEffect)mobEffect.value()).getCategory() != MobEffectCategory.HARMFUL) continue;
                negativeEffects.add(mobEffect);
            }
            for (Holder mobEffectHolder : negativeEffects) {
                if (!toggleableTool.canUseAbilityAndDurability(itemStack, Ability.DEBUFFREMOVER)) continue;
                player.removeEffect(mobEffectHolder);
                Helpers.damageTool(itemStack, (LivingEntity)player, Ability.DEBUFFREMOVER);
            }
        }
        return false;
    }

    public static boolean earthquake(Level level, Player player, ItemStack itemStack) {
        ToggleableTool toggleableTool;
        if (level.isClientSide) {
            return false;
        }
        int currentCooldown = ToggleableTool.getAnyCooldown(itemStack, Ability.EARTHQUAKE);
        if (currentCooldown != -1) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.EARTHQUAKE)) {
            AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.EARTHQUAKE);
            ToggleableTool.addCooldown(itemStack, Ability.EARTHQUAKE, abilityParams.activeCooldown, true);
            player.playNotifySound(SoundEvents.MACE_SMASH_GROUND_HEAVY, SoundSource.PLAYERS, 1.0f, 0.5f);
            int radius = 5;
            AABB aabb = new AABB(player.getX() - (double)radius, player.getY() - (double)radius, player.getZ() - (double)radius, player.getX() + (double)radius, player.getY() + (double)radius, player.getZ() + (double)radius);
            ArrayList earthquakeList = new ArrayList(level.getEntitiesOfClass(Mob.class, aabb, AbilityMethods::isValidEarthquake));
            for (Mob mob : earthquakeList) {
                if (!toggleableTool.canUseAbilityAndDurability(itemStack, Ability.EARTHQUAKE)) continue;
                mob.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 3), (Entity)mob);
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.END_ROD, mob.getX(), mob.getY(), mob.getZ(), 20, 0.25, 0.2, 0.25, 0.0);
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, mob.getX(), mob.getY(), mob.getZ(), 20, 0.5, 0.2, 0.5, 0.0);
                Helpers.damageTool(itemStack, (LivingEntity)player, Ability.EARTHQUAKE);
            }
        }
        return false;
    }

    public static boolean noAI(Level level, Player player, ItemStack itemStack) {
        ToggleableTool toggleableTool;
        if (level.isClientSide) {
            return false;
        }
        int currentCooldown = ToggleableTool.getAnyCooldown(itemStack, Ability.NOAI);
        if (currentCooldown != -1) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.NOAI)) {
            AbilityParams abilityParams = toggleableTool.getAbilityParams(Ability.NOAI);
            ToggleableTool.addCooldown(itemStack, Ability.NOAI, abilityParams.cooldown, false);
            int radius = 5;
            AABB aabb = new AABB(player.getX() - (double)radius, player.getY() - (double)radius, player.getZ() - (double)radius, player.getX() + (double)radius, player.getY() + (double)radius, player.getZ() + (double)radius);
            ArrayList AIList = new ArrayList(level.getEntitiesOfClass(Mob.class, aabb, AbilityMethods::isValidNOAIEntity));
            for (Mob mob : AIList) {
                if (!toggleableTool.canUseAbilityAndDurability(itemStack, Ability.NOAI)) continue;
                mob.setNoAi(true);
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.END_ROD, mob.getX(), mob.getEyeY(), mob.getZ(), 20, 0.25, 0.2, 0.25, 0.0);
                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.ENCHANT, mob.getX(), mob.getEyeY(), mob.getZ(), 20, 0.5, 0.2, 0.5, 0.0);
                Helpers.damageTool(itemStack, (LivingEntity)player, Ability.NOAI);
            }
            player.playNotifySound(SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 0.5f);
            player.playNotifySound(SoundEvents.SCULK_SHRIEKER_SHRIEK, SoundSource.PLAYERS, 1.0f, 0.25f);
        }
        return false;
    }

    public static boolean epicArrow(Level level, Player player, ItemStack itemStack) {
        ToggleableTool toggleableTool;
        if (level.isClientSide) {
            return false;
        }
        int currentCooldown = ToggleableTool.getAnyCooldown(itemStack, Ability.EPICARROW);
        if (currentCooldown != -1) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof ToggleableTool && (toggleableTool = (ToggleableTool)item).canUseAbilityAndDurability(itemStack, Ability.EPICARROW) && !((Boolean)itemStack.getOrDefault(JustDireDataComponents.EPIC_ARROW, (Object)false)).booleanValue()) {
            itemStack.set(JustDireDataComponents.EPIC_ARROW, (Object)true);
            player.playNotifySound(SoundEvents.EVOKER_PREPARE_SUMMON, SoundSource.PLAYERS, 1.0f, 0.5f);
            Helpers.damageTool(itemStack, (LivingEntity)player, Ability.EPICARROW);
        }
        return false;
    }

    public static boolean flight(Level level, Player player, ItemStack itemStack) {
        if (level.isClientSide) {
            return false;
        }
        if (player.getAbilities().flying) {
            Helpers.damageTool(itemStack, (LivingEntity)player, Ability.FLIGHT);
        }
        return false;
    }

    public static boolean isValidStompEntity(Entity entity) {
        if (entity.isMultipartEntity()) {
            return false;
        }
        return !(entity instanceof PartEntity);
    }

    public static boolean isValidNOAIEntity(Entity entity) {
        if (entity.isMultipartEntity()) {
            return false;
        }
        if (entity instanceof PartEntity) {
            return false;
        }
        return !entity.getType().is(JustDireEntityTags.NO_AI_DENY);
    }

    public static boolean isValidEarthquake(Entity entity) {
        if (!entity.onGround()) {
            return false;
        }
        if (entity.isMultipartEntity()) {
            return false;
        }
        if (entity instanceof PartEntity) {
            return false;
        }
        return !entity.getType().is(JustDireEntityTags.NO_EARTHQUAKE);
    }

    public static List<String> getStupefyTargets(ItemStack itemStack) {
        return (List)itemStack.getOrDefault((DataComponentType)JustDireDataComponents.STUPEFY_TARGETS.get(), new ArrayList());
    }

    public static void addStupefyTarget(ItemStack itemStack, String entityUUID) {
        ArrayList<String> stupefyTargets = new ArrayList<String>(AbilityMethods.getStupefyTargets(itemStack));
        stupefyTargets.add(entityUUID);
        itemStack.set(JustDireDataComponents.STUPEFY_TARGETS, stupefyTargets);
    }

    public static void clearStupefyTargets(ItemStack itemStack) {
        itemStack.set(JustDireDataComponents.STUPEFY_TARGETS, new ArrayList());
    }

    private static EntityType<?> getRandomMobTypeByCategory(Level level, boolean peaceful) {
        List<EntityType> mobTypes = BuiltInRegistries.ENTITY_TYPE.stream().filter(type -> peaceful ? type.is(JustDireEntityTags.POLYMORPHIC_PEACEFUL) : type.is(JustDireEntityTags.POLYMORPHIC_HOSTILE)).toList();
        return mobTypes.isEmpty() ? null : mobTypes.get(level.random.nextInt(mobTypes.size()));
    }
}

