/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.util;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class MiscHelpers {
    private static final Random rand = new Random();

    public static double nextDouble(double min, double max) {
        return min + (max - min) * rand.nextDouble();
    }

    public static IItemHandler getAttachedInventory(Level level, BlockPos blockPos, Direction side) {
        if (level == null) {
            return null;
        }
        BlockEntity be = level.getBlockEntity(blockPos);
        if (be != null) {
            IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, blockPos, (Object)side);
            return handler;
        }
        return null;
    }

    public static Direction getPrimaryDirection(Vec3 vec) {
        double absX = Math.abs(vec.x);
        double absY = Math.abs(vec.y);
        double absZ = Math.abs(vec.z);
        if (absX > absY && absX > absZ) {
            return vec.x > 0.0 ? Direction.EAST : Direction.WEST;
        }
        if (absY > absX && absY > absZ) {
            return vec.y > 0.0 ? Direction.UP : Direction.DOWN;
        }
        return vec.z > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    public static Direction getFacingDirection(Player player) {
        float yaw = player.getYRot();
        float pitch = player.getXRot();
        Direction horizontalDirection = Direction.fromYRot((double)yaw);
        if (pitch < -45.0f) {
            return Direction.UP;
        }
        if (pitch > 45.0f) {
            return Direction.DOWN;
        }
        return horizontalDirection;
    }

    public static enum RedstoneMode {
        IGNORED,
        LOW,
        HIGH,
        PULSE;


        public RedstoneMode next() {
            RedstoneMode[] values = RedstoneMode.values();
            int nextOrdinal = (this.ordinal() + 1) % values.length;
            return values[nextOrdinal];
        }
    }
}

