/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivedamageindicators.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector2i;
import toni.immersivedamageindicators.api.CreateDamageIndicator;
import toni.immersivedamageindicators.foundation.CaxtonRenderer;
import toni.immersivedamageindicators.foundation.IrisCompat;
import toni.immersivedamageindicators.foundation.ParticleRegistry;
import toni.immersivedamageindicators.foundation.config.AllConfigs;
import toni.immersivemessages.ImmersiveMessagesManager;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.api.TextAnchor;
import toni.lib.animation.AnimationKeyframe;
import toni.lib.animation.AnimationTimeline;
import toni.lib.animation.Binding;
import toni.lib.animation.PoseUtils;
import toni.lib.animation.easing.EasingType;
import toni.lib.utils.ColorUtils;
import toni.lib.utils.PlatformUtils;

public class DamageParticle
extends Particle {
    private static final List<Float> POSITIONS = new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(-0.25f), Float.valueOf(0.12f), Float.valueOf(-0.12f), Float.valueOf(0.25f)));
    private static final DecimalFormat DF2 = new DecimalFormat("#.##");
    private static final DecimalFormat DF1 = new DecimalFormat("#.#");
    private final Font fontRenderer;
    public final ImmersiveMessage message;
    public float fadeout;
    public float prevFadeout;
    public float visualDY;
    public float prevVisualDY;
    public float visualDX;
    public float prevVisualDX;
    public int opacity;

    public DamageParticle(ClientLevel clientLevel, double x, double y, double z, double amount, double dColor, double dz) {
        super(clientLevel, x, y, z);
        this.fontRenderer = Minecraft.getInstance().font;
        this.fadeout = -1.0f;
        this.prevFadeout = -1.0f;
        this.visualDY = 0.0f;
        this.prevVisualDY = 0.0f;
        this.visualDX = 0.0f;
        this.prevVisualDX = 0.0f;
        this.lifetime = 35;
        boolean isCrit = dz > 1.0;
        MutableComponent text = Component.literal((String)((amount < 0.0 ? "+" : "") + DF1.format(amount) + (isCrit && (Boolean)AllConfigs.client().showExclamationPoint.get() != false ? "!" : "")));
        this.xd = 0.0;
        this.yd = 1.0;
        double sqDz = Math.sqrt(dz);
        Integer defaultColor = (Integer)AllConfigs.client().textColor.get();
        Integer hurtColor = (Integer)AllConfigs.client().hurtColor.get();
        this.opacity = (Integer)AllConfigs.client().alpha.get();
        int startColor = ColorUtils.lerp((float)Mth.clamp((float)((float)dz / 1.25f), (float)0.0f, (float)1.0f), (int)defaultColor, (int)hurtColor);
        int endColor = ColorUtils.lerp((float)Mth.clamp((float)((float)dz / 4.0f), (float)(isCrit ? 0.75f : 0.0f), (float)1.0f), (int)defaultColor, (int)hurtColor);
        float endTime = (float)Math.max(1.0, dz * 4.5);
        this.message = ImmersiveMessage.builder((float)5.0f, (MutableComponent)text).anchor(TextAnchor.CENTER_CENTER).slideUp().fadeIn().size(1.0f).animation(anim -> {
            if (((Boolean)AllConfigs.client().doSizeEffects.get()).booleanValue()) {
                anim.transition(Binding.Size, 0.0f, 1.0f, 0.0f, isCrit ? 3.0f : 2.0f, EasingType.EaseOutExpo);
                anim.transition(Binding.Size, 1.0f, 2.5f, isCrit ? 3.0f : 2.0f, isCrit ? 1.5f : 1.0f, EasingType.EaseInOutSine);
            }
            if (((Boolean)AllConfigs.client().doColorEffects.get()).booleanValue()) {
                anim.transition(Binding.Color, 0.0f, endTime, (float)startColor, (float)endColor, EasingType.EaseOutSine);
            }
            if (((Boolean)AllConfigs.client().doShakeEffects.get()).booleanValue()) {
                anim.waveEffect(Binding.zRot, (float)(isCrit ? 5.0 : 3.0 * sqDz), (float)(isCrit ? 20.0 : 5.0 * sqDz), 0.0f, 5.0f);
            }
        }).fadeOut();
        if (PlatformUtils.isModLoaded((String)"caxton") && !IrisCompat.areShadersEnabled()) {
            this.message.font(AllConfigs.client().getFont().toString());
        }
        this.message.onPoseMessage = this::applyPose;
        ((CreateDamageIndicator)CreateDamageIndicator.EVENT.invoker()).onCreateDamageIndicator(this, this.message);
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        boolean forceVanilla;
        Vec3 cameraPos = camera.getPosition();
        float particleX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x());
        float particleY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y());
        float particleZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z());
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        GuiGraphics graphics = new GuiGraphics(Minecraft.getInstance(), buffer);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(particleX, particleY, particleZ);
        double distanceFromCam = new Vec3((double)particleX, (double)particleY, (double)particleZ).length();
        double inc = Mth.clamp((double)(distanceFromCam / 32.0), (double)0.0, (double)5.0);
        poseStack.translate(0.0, (1.0 + inc / 4.0) * (double)Mth.lerp((float)partialTicks, (float)this.prevVisualDY, (float)this.visualDY), 0.0);
        float d2r = (float)Math.PI / 180;
        Quaternionf quat = new Quaternionf().rotationYXZ(camera.getYRot() * -d2r, camera.getXRot() * d2r, 0.0f);
        poseStack.mulPose(quat);
        float fadeout = Mth.lerp((float)partialTicks, (float)this.prevFadeout, (float)this.fadeout);
        float defScale = 0.006f;
        float scale = (float)((double)defScale * distanceFromCam);
        poseStack.translate((1.0 + inc) * (double)Mth.lerp((float)partialTicks, (float)this.prevVisualDX, (float)this.visualDX), 0.0, 0.0);
        poseStack.scale(-scale, -scale, scale);
        poseStack.translate(0.0, 4.0 * (double)(1.0f - fadeout), 0.0);
        poseStack.translate(0.0, -distanceFromCam / 10.0, 0.0);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        this.message.onRenderMessage = this::renderMessage;
        if (PlatformUtils.isModLoaded((String)"caxton")) {
            this.message.onRenderMessageCaxton = (tooltip, g, r, t, y) -> CaxtonRenderer.renderMessageCaxton(this, tooltip, g, r, t, y);
        }
        if (forceVanilla = IrisCompat.areShadersEnabled()) {
            ImmersiveMessagesManager.forceVanillaRenderer = true;
        }
        this.message.render(graphics, partialTicks);
        if (forceVanilla) {
            ImmersiveMessagesManager.forceVanillaRenderer = false;
        }
        poseStack.popPose();
    }

    public void renderMessage(ImmersiveMessage tooltip, GuiGraphics graphics, FormattedText line, int yOffset) {
        Matrix4f mat = graphics.pose().last().pose();
        MultiBufferSource.BufferSource renderType = graphics.bufferSource();
        Font font = Minecraft.getInstance().font;
        float fade = (float)FastColor.ARGB32.alpha((int)tooltip.animation.getColor()) / 255.0f;
        int alpha = (int)Math.max(0.0f, Math.min((float)this.opacity, fade * (float)this.opacity));
        int color = tooltip.animation.getColor();
        font.drawInBatch(Language.getInstance().getVisualOrder(line), 0.0f, (float)yOffset, ColorUtils.color((int)alpha, (int)ColorUtils.red((int)color), (int)ColorUtils.green((int)color), (int)ColorUtils.blue((int)color)), false, mat, (MultiBufferSource)renderType, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        graphics.pose().translate(0.5, 0.5, 0.03);
        font.drawInBatch((Component)Component.literal((String)line.getString()), 0.0f, (float)yOffset, FastColor.ARGB32.color((int)alpha, (int)40, (int)40, (int)40), false, mat, (MultiBufferSource)renderType, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public AnimationKeyframe applyPose(ImmersiveMessage message, AnimationTimeline animation, GuiGraphics context, Vector2i bgOffset, TextAnchor anchor, TextAnchor align, float objectWidth, float objectHeight) {
        AnimationKeyframe key = animation.getKeyframe();
        if (key.size != 1.0f) {
            context.pose().translate(objectWidth / 2.0f, objectHeight / 2.0f, 0.0f);
            context.pose().scale(key.size, key.size, key.size);
            context.pose().translate(objectWidth / -2.0f, objectHeight / -2.0f, 0.0f);
        }
        if (key.rotY != 0.0f) {
            PoseUtils.applyYRotation((GuiGraphics)context, (float)key.size, (float)objectWidth, (float)objectHeight, (float)key.rotY);
        }
        if (key.rotX != 0.0f) {
            PoseUtils.applyXRotation((GuiGraphics)context, (float)key.size, (float)objectWidth, (float)objectHeight, (float)key.rotX);
        }
        if (key.rotZ != 0.0f) {
            PoseUtils.applyZRotation((GuiGraphics)context, (float)key.size, (float)objectWidth, (float)objectHeight, (float)key.rotZ);
        }
        return key;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            float length = 6.0f;
            this.prevFadeout = this.fadeout;
            this.fadeout = (float)this.age > (float)this.lifetime - length ? ((float)this.lifetime - (float)this.age) / length : 1.0f;
            this.prevVisualDY = this.visualDY;
            this.visualDY = (float)((double)this.visualDY + this.yd);
            this.prevVisualDX = this.visualDX;
            this.visualDX = (float)((double)this.visualDX + this.xd);
            if (Math.sqrt(Mth.square((double)((double)this.visualDX * 1.5)) + (double)Mth.square((float)(this.visualDY - 1.0f))) < 0.8999999999999999) {
                this.yd /= 2.0;
            } else {
                this.yd = 0.0;
                this.xd = 0.0;
            }
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet spriteSet) {
        }

        @SubscribeEvent
        public static void register(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ParticleRegistry.DAMAGE_PARTICLE, Factory::new);
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DamageParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

