/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common;

import com.simibubi.create.foundation.item.ItemDescription;
import java.util.concurrent.CompletableFuture;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import plus.dragons.createdragonsplus.common.CDPRegistrate;
import plus.dragons.createdragonsplus.common.registry.CDPBlockEntities;
import plus.dragons.createdragonsplus.common.registry.CDPBlockFreezers;
import plus.dragons.createdragonsplus.common.registry.CDPBlocks;
import plus.dragons.createdragonsplus.common.registry.CDPConditions;
import plus.dragons.createdragonsplus.common.registry.CDPCreativeModeTabs;
import plus.dragons.createdragonsplus.common.registry.CDPCriterions;
import plus.dragons.createdragonsplus.common.registry.CDPDataMaps;
import plus.dragons.createdragonsplus.common.registry.CDPFanProcessingTypes;
import plus.dragons.createdragonsplus.common.registry.CDPFluids;
import plus.dragons.createdragonsplus.common.registry.CDPItemAttributes;
import plus.dragons.createdragonsplus.common.registry.CDPItems;
import plus.dragons.createdragonsplus.common.registry.CDPRecipes;
import plus.dragons.createdragonsplus.config.CDPConfig;
import plus.dragons.createdragonsplus.data.internal.CDPRuntimeRecipeProvider;
import plus.dragons.createdragonsplus.data.runtime.RuntimePackResources;
import plus.dragons.createdragonsplus.integration.ModIntegration;

@Mod(value="create_dragons_plus")
public class CDPCommon {
    public static final String ID = "create_dragons_plus";
    public static final String NAME = "Create: Dragons Plus";
    public static final String PERSISTENT_DATA_KEY = "CreateDragonsPlusData";
    public static final CDPRegistrate REGISTRATE = new CDPRegistrate("create_dragons_plus").setTooltipModifier(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE));
    private final ModContainer modContainer;
    private final Component runtimePackTitle = REGISTRATE.addLang("pack", CDPCommon.asResource("runtime"), "Create: Dragons Plus");
    private final Component runtimePackDescription = REGISTRATE.addLang("pack", CDPCommon.asResource("runtime"), "description", "Create: Dragons Plus Runtime Generated Resources");

    public CDPCommon(IEventBus modBus, ModContainer modContainer) {
        this.modContainer = modContainer;
        REGISTRATE.registerEventListeners(modBus);
        CDPFluids.register(modBus);
        CDPBlocks.register(modBus);
        CDPBlockEntities.register(modBus);
        CDPItems.register(modBus);
        CDPCreativeModeTabs.register(modBus);
        CDPCriterions.register(modBus);
        CDPRecipes.register(modBus);
        CDPConditions.register(modBus);
        CDPFanProcessingTypes.register(modBus);
        CDPItemAttributes.register(modBus);
        CDPDataMaps.register(modBus);
        modBus.register((Object)this);
        modBus.register((Object)new CDPConfig(modContainer));
    }

    @SubscribeEvent
    public void construct(FMLConstructModEvent event) {
        for (ModIntegration integration : ModIntegration.values()) {
            if (!integration.enabled()) continue;
            event.enqueueWork(integration::onConstructMod);
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(CDPBlockFreezers::register);
        for (ModIntegration integration : ModIntegration.values()) {
            if (!integration.enabled()) continue;
            event.enqueueWork(integration::onCommonSetup);
        }
    }

    @SubscribeEvent
    public void addPackFinders(AddPackFindersEvent event) {
        PackType type = event.getPackType();
        if (type == PackType.SERVER_DATA) {
            RuntimePackResources pack = new RuntimePackResources("runtime", this.modContainer, type, Pack.Position.TOP, this.runtimePackTitle, this.runtimePackDescription);
            CompletableFuture<RegistryAccess.Frozen> registries = CompletableFuture.completedFuture(RegistryLayer.createRegistryAccess().compositeAccess());
            pack.addDataProvider((DataProvider)new CDPRuntimeRecipeProvider(pack.getPackOutput(), registries));
            event.addRepositorySource((RepositorySource)pack);
        }
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }
}

