/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.advancements.criterion;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.StatAwardEvent;
import plus.dragons.createdragonsplus.common.registry.CDPCriterions;
import plus.dragons.createdragonsplus.util.CDPCodecs;

public class StatTrigger
implements CriterionTrigger<Instance> {
    private final Table<PlayerAdvancements, Stat<?>, Set<CriterionTrigger.Listener<Instance>>> listeners = Tables.newCustomTable(new IdentityHashMap(), IdentityHashMap::new);

    public StatTrigger() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onStatAwardEvent(StatAwardEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Stat stat = event.getStat();
            PlayerAdvancements advancements = player2.getAdvancements();
            Set listeners = (Set)this.listeners.get((Object)advancements, (Object)stat);
            if (listeners == null || listeners.isEmpty()) {
                return;
            }
            int value = event.getValue();
            for (CriterionTrigger.Listener listener : listeners) {
                Instance trigger = (Instance)listener.trigger();
                if (!trigger.bounds().matches(value)) continue;
                listener.run(advancements);
            }
        }
    }

    public final void addPlayerListener(PlayerAdvancements advancements, CriterionTrigger.Listener<Instance> listener) {
        Stat<?> stat = ((Instance)listener.trigger()).stat;
        HashSet<CriterionTrigger.Listener<Instance>> set = (HashSet<CriterionTrigger.Listener<Instance>>)this.listeners.get((Object)advancements, stat);
        if (set == null) {
            set = new HashSet<CriterionTrigger.Listener<Instance>>();
            this.listeners.put((Object)advancements, stat, set);
        }
        set.add(listener);
    }

    public final void removePlayerListener(PlayerAdvancements advancements, CriterionTrigger.Listener<Instance> listener) {
        Stat<?> stat = ((Instance)listener.trigger()).stat;
        Set set = (Set)this.listeners.get((Object)advancements, stat);
        if (set != null) {
            set.remove(listener);
            if (set.isEmpty()) {
                this.listeners.remove((Object)advancements, stat);
            }
        }
    }

    public final void removePlayerListeners(PlayerAdvancements advancements) {
        this.listeners.rowMap().remove(advancements);
    }

    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public record Instance(Stat<?> stat, MinMaxBounds.Ints bounds) implements CriterionTriggerInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CDPCodecs.STAT.forGetter(Instance::stat), (App)MinMaxBounds.Ints.CODEC.fieldOf("bounds").forGetter(Instance::bounds)).apply((Applicative)instance, Instance::new));

        public static Criterion<Instance> of(Stat<?> stat, MinMaxBounds.Ints bounds) {
            return ((StatTrigger)CDPCriterions.STAT.get()).createCriterion(new Instance(stat, bounds));
        }

        public static Criterion<Instance> of(ResourceLocation stat, MinMaxBounds.Ints bounds) {
            return ((StatTrigger)CDPCriterions.STAT.get()).createCriterion(new Instance(Stats.CUSTOM.get((Object)stat), bounds));
        }

        public void validate(CriterionValidator validator) {
        }
    }
}

