/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.integration.jei.category;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import plus.dragons.createdragonsplus.common.CDPCommon;
import plus.dragons.createdragonsplus.common.kinetics.fan.sanding.SandingRecipe;
import plus.dragons.createdragonsplus.common.registry.CDPBlocks;
import plus.dragons.createdragonsplus.common.registry.CDPRecipes;
import plus.dragons.createdragonsplus.data.internal.CDPLang;
import plus.dragons.createdragonsplus.integration.CompatUtility;
import plus.dragons.createdragonsplus.integration.ModIntegration;
import plus.dragons.createdragonsplus.integration.jei.CDPJeiPlugin;
import plus.dragons.createdragonsplus.integration.jei.widget.FanProcessingIcon;
import plus.dragons.createdragonsplus.util.FieldsNullabilityUnknownByDefault;

@FieldsNullabilityUnknownByDefault
public class FanSandingCategory
extends ProcessingViaFanCategory<SandingRecipe> {
    public static final RecipeType<RecipeHolder<SandingRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)CDPRecipes.SANDING.getId());
    private HolderSet<Block> catalystBlocks;
    private BlockState[] catalystStates;

    private FanSandingCategory(CreateRecipeCategory.Info<SandingRecipe> info) {
        super(info);
    }

    public static FanSandingCategory create() {
        ResourceLocation id = CDPCommon.asResource("fan_sanding");
        MutableComponent title = CDPLang.description("recipe", id, new Object[0]).component();
        EmptyBackground background = new EmptyBackground(178, 72);
        Icon icon = new Icon();
        ItemStack catalyst = AllBlocks.ENCASED_FAN.asStack();
        catalyst.set(DataComponents.CUSTOM_NAME, (Object)CDPLang.description("recipe", id, "fan", new Object[0]).component().withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(TYPE, (Component)title, (IDrawable)background, (IDrawable)icon, FanSandingCategory::getAllRecipes, CompatUtility.catalystWithIndustryFan(catalyst));
        return new FanSandingCategory((CreateRecipeCategory.Info<SandingRecipe>)info);
    }

    protected void renderAttachedBlock(GuiGraphics graphics) {
        Optional optional = BuiltInRegistries.BLOCK.getTag(CDPBlocks.MOD_TAGS.fanSandingCatalysts);
        if (optional.isEmpty()) {
            return;
        }
        if (this.catalystBlocks != optional.get()) {
            this.catalystBlocks = (HolderSet)optional.get();
            this.catalystStates = (BlockState[])this.catalystBlocks.stream().map(Holder::value).map(Block::defaultBlockState).toArray(BlockState[]::new);
        }
        if (this.catalystStates.length == 0) {
            return;
        }
        GuiGameElement.of((BlockState)this.catalystStates[AnimationTickHolder.getTicks() / 20 % this.catalystStates.length]).scale(24.0).atLocal(0.0, 0.0, 2.0).lighting(AnimatedKinetics.DEFAULT_LIGHTING).render(graphics);
    }

    public boolean isHandled(RecipeHolder<SandingRecipe> recipe) {
        Optional tag = BuiltInRegistries.BLOCK.getTag(CDPBlocks.MOD_TAGS.fanSandingCatalysts);
        return tag.isPresent() && ((HolderSet.Named)tag.get()).size() > 0 || ModIntegration.CREATE_DND.enabled();
    }

    private static List<RecipeHolder<SandingRecipe>> getAllRecipes() {
        Level level = CDPJeiPlugin.getLevel();
        RecipeManager manager = CDPJeiPlugin.getRecipeManager();
        ArrayList<RecipeHolder<SandingRecipe>> recipes = new ArrayList<RecipeHolder<SandingRecipe>>(manager.getAllRecipesFor(CDPRecipes.SANDING.getType()));
        manager.getAllRecipesFor(AllRecipeTypes.SANDPAPER_POLISHING.getType()).stream().filter(AllRecipeTypes.CAN_BE_AUTOMATED).map(SandingRecipe::convertSandPaperPolishing).forEach(recipes::add);
        DeferredHolder createDNDRecipe = DeferredHolder.create((ResourceKey)Registries.RECIPE_TYPE, (ResourceLocation)ModIntegration.CREATE_DND.asResource("sanding"));
        if (createDNDRecipe.isBound()) {
            manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)createDNDRecipe.get()).forEach(holder -> recipes.add(new RecipeHolder(holder.id(), (Recipe)((SandingRecipe)((StandardProcessingRecipe.Builder)((StandardProcessingRecipe.Builder)SandingRecipe.builder(holder.id()).withItemIngredients(((StandardProcessingRecipe)holder.value()).getIngredients())).withItemOutputs((ProcessingOutput[])((StandardProcessingRecipe)holder.value()).getRollableResults().toArray(ProcessingOutput[]::new))).build()))));
        }
        return recipes;
    }

    protected static class Icon
    extends FanProcessingIcon {
        private HolderSet<Block> catalystBlocks;
        private ItemStack[] catalystStacks;

        protected Icon() {
        }

        @Override
        protected ItemStack getCatalyst() {
            Optional optional = BuiltInRegistries.BLOCK.getTag(CDPBlocks.MOD_TAGS.fanSandingCatalysts);
            if (optional.isEmpty()) {
                return ItemStack.EMPTY;
            }
            if (this.catalystBlocks != optional.get()) {
                this.catalystBlocks = (HolderSet)optional.get();
                this.catalystStacks = (ItemStack[])this.catalystBlocks.stream().map(Holder::value).map(ItemStack::new).toArray(ItemStack[]::new);
            }
            if (this.catalystStacks.length == 0) {
                return ItemStack.EMPTY;
            }
            return this.catalystStacks[AnimationTickHolder.getTicks() / 20 % this.catalystStacks.length];
        }
    }
}

