/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.common.client.rendering;

import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class AbstractCachedDynamicModel
implements BakedModel {
    private final Map<String, BakedModel> cache = new HashMap<String, BakedModel>();
    private final Map<ModelResourceLocation, BakedModel> baseModelCache = new HashMap<ModelResourceLocation, BakedModel>();
    private final Map<ModelResourceLocation, UnbakedModel> unbakedModels = new HashMap<ModelResourceLocation, UnbakedModel>();
    private final ModelBakery modelBakery;
    private final Function<ModelResourceLocation, UnbakedModel> modelResolver;
    private final Function<BlockState, ModelResourceLocation> baseModelFunction;
    private final List<Pair<Predicate<BlockState>, BakedModel>> parts;
    private final Function<BlockState, Map<String, String>> textureMapFunction;
    private final BiConsumer<BlockState, Matrix4f> transformFunction;
    private final ModelResourceLocation location;
    private final ModelBakery.TextureGetter textureGetter;
    private TextureAtlasSprite particleTexture;

    public AbstractCachedDynamicModel(ModelBakery modelBakery, Map<ModelResourceLocation, UnbakedModel> models, Function<BlockState, ModelResourceLocation> baseModelFunction, @Nullable List<Pair<Predicate<BlockState>, BakedModel>> parts, @Nullable Function<BlockState, Map<String, String>> textureMapFunction, @Nullable BiConsumer<BlockState, Matrix4f> transformFunction, List<RenderType> renderTypes, ModelResourceLocation location, ModelBakery.TextureGetter textureGetter) {
        this.modelBakery = modelBakery;
        this.unbakedModels.putAll(models);
        this.modelResolver = this.unbakedModels::get;
        this.baseModelFunction = baseModelFunction;
        this.parts = parts;
        this.textureMapFunction = textureMapFunction;
        this.transformFunction = transformFunction;
        this.location = location;
        this.textureGetter = textureGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        if (state != null) {
            BakedModel bakedModel;
            Matrix4f transform = BlockModelRotation.X0_Y0.getRotation().getMatrix();
            String stateString = state.toString();
            Map<String, BakedModel> map = this.cache;
            synchronized (map) {
                bakedModel = this.cache.get(stateString);
                if (bakedModel == null) {
                    if (this.transformFunction != null) {
                        this.transformFunction.accept(state, transform);
                    }
                    BalmModels models = BalmClient.getModels();
                    ModelState modelTransform = models.getModelState(new Transformation(transform));
                    ModelResourceLocation baseModelLocation = this.baseModelFunction.apply(state);
                    if (this.textureMapFunction != null && !this.baseModelCache.containsKey(baseModelLocation)) {
                        UnbakedModel baseModel = this.modelResolver.apply(baseModelLocation);
                        BakedModel bakedBaseModel = baseModel.bake(models.createBaker(baseModelLocation, this.textureGetter), Material::sprite, modelTransform);
                        this.baseModelCache.put(baseModelLocation, bakedBaseModel);
                    }
                    UnbakedModel retexturedBaseModel = this.textureMapFunction != null ? models.retexture(this.modelBakery, baseModelLocation, this.textureMapFunction.apply(state)) : this.modelResolver.apply(baseModelLocation);
                    bakedModel = retexturedBaseModel.bake(models.createBaker(this.location, this.textureGetter), Material::sprite, modelTransform);
                    this.cache.put(stateString, bakedModel);
                    if (this.particleTexture == null && bakedModel != null) {
                        this.particleTexture = bakedModel.getParticleIcon();
                    }
                }
            }
            return bakedModel != null ? bakedModel.getQuads(state, side, rand) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particleTexture != null ? this.particleTexture : new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation()).sprite();
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public abstract List<RenderType> getBlockRenderTypes(BlockState var1, RandomSource var2);

    public abstract List<RenderType> getItemRenderTypes(ItemStack var1, boolean var2);
}

