/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge.capability;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.capability.BalmCapabilities;
import net.blay09.mods.balm.api.capability.CapabilityType;
import net.blay09.mods.balm.common.NamespaceResolver;
import net.blay09.mods.balm.neoforge.ModBusEventRegisters;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;

public record NeoForgeBalmCapabilities(NamespaceResolver namespaceResolver) implements BalmCapabilities
{
    private static final Map<ResourceLocation, CapabilityType<?, ?, ?>> types = new ConcurrentHashMap();
    private static final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    @Override
    public <TApi, TContext> TApi getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, TContext context, CapabilityType<Block, TApi, TContext> type) {
        BlockCapability capability = (BlockCapability)type.backingType();
        return (TApi)level.getCapability(capability, pos, state, blockEntity, context);
    }

    @Override
    public <TScope, TApi, TContext> CapabilityType<TScope, TApi, TContext> registerType(ResourceLocation identifier, Class<TScope> scopeClass, Class<TApi> apiClass, Class<TContext> contextClass) {
        if (scopeClass == Block.class) {
            BlockCapability capability = BlockCapability.create((ResourceLocation)identifier, apiClass, contextClass);
            CapabilityType<TScope, TApi, TContext> type = new CapabilityType<TScope, TApi, TContext>(identifier, scopeClass, apiClass, contextClass, capability);
            types.put(identifier, type);
            return type;
        }
        throw new IllegalArgumentException("Unsupported scope class: " + String.valueOf(scopeClass));
    }

    @Override
    public <TScope, TApi, TContext> CapabilityType<TScope, TApi, TContext> getType(ResourceLocation identifier, Class<TScope> scopeClass, Class<TApi> apiClass, Class<TContext> contextClass) {
        CapabilityType<Object, Object, Object> type = types.get(identifier);
        if (type == null) {
            type = this.registerType(identifier, scopeClass, apiClass, contextClass);
        }
        if (type.scopeClass() != scopeClass) {
            throw new IllegalArgumentException("Incompatible scope for capability " + String.valueOf(identifier) + ", expected " + String.valueOf(type.scopeClass()) + " but got " + String.valueOf(scopeClass));
        }
        if (type.apiClass() != apiClass) {
            throw new IllegalArgumentException("Incompatible API for capability " + String.valueOf(identifier) + ", expected " + String.valueOf(type.apiClass()) + " but got " + String.valueOf(apiClass));
        }
        if (type.contextClass() != contextClass) {
            throw new IllegalArgumentException("Incompatible context for capability " + String.valueOf(identifier) + ", expected " + String.valueOf(type.contextClass()) + " but got " + String.valueOf(contextClass));
        }
        return type;
    }

    @Override
    public <TApi, TContext> void registerProvider(ResourceLocation identifier, CapabilityType<Block, TApi, TContext> type, BiFunction<BlockEntity, TContext, TApi> provider, Supplier<List<BlockEntityType<?>>> blockEntityTypes) {
        this.getActiveRegistrations().blockEntityProviders.add(new BlockEntityProviderRegistration<TApi, TContext>(type, provider, blockEntityTypes));
    }

    @Override
    public <TApi, TContext> void registerFallbackBlockEntityProvider(ResourceLocation identifier, CapabilityType<Block, TApi, TContext> type, BiFunction<BlockEntity, TContext, TApi> provider) {
        this.getActiveRegistrations().fallbackBlockEntityProviders.add(new BlockEntityFallbackProviderRegistration<TApi, TContext>(type, provider));
    }

    public <TApi, TContext> CapabilityType<Block, TApi, TContext> addExistingType(ResourceLocation identifier, BaseCapability<TApi, TContext> capability) {
        if (capability instanceof BlockCapability) {
            CapabilityType type = new CapabilityType(identifier, Block.class, capability.typeClass(), capability.contextClass(), capability);
            types.put(identifier, type);
            return type;
        }
        throw new IllegalArgumentException("Unsupported capability type " + String.valueOf(capability.getClass()));
    }

    private Registrations getActiveRegistrations() {
        return ModBusEventRegisters.getRegistrations(this.namespaceResolver.getDefaultNamespace(), Registrations.class);
    }

    public static class Registrations {
        public final List<BlockEntityProviderRegistration<?, ?>> blockEntityProviders = new ArrayList();
        public final List<BlockEntityFallbackProviderRegistration<?, ?>> fallbackBlockEntityProviders = new ArrayList();

        @SubscribeEvent
        public void registerCapabilities(RegisterCapabilitiesEvent event) {
            for (BlockEntityProviderRegistration<?, ?> blockEntityProvider : this.blockEntityProviders) {
                this.doRegister(event, blockEntityProvider);
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void registerFallbackCapabilities(RegisterCapabilitiesEvent event) {
            for (BlockEntityFallbackProviderRegistration<?, ?> fallbackBlockEntityProvider : this.fallbackBlockEntityProviders) {
                this.doRegister(event, fallbackBlockEntityProvider);
            }
        }

        private <TApi, TContext> void doRegister(RegisterCapabilitiesEvent event, final BlockEntityProviderRegistration<TApi, TContext> registration) {
            Block[] blocks = (Block[])registration.blockEntityTypes.get().stream().flatMap(it -> it.getValidBlocks().stream()).distinct().toArray(Block[]::new);
            BlockCapability capability = (BlockCapability)registration.type().backingType();
            event.registerBlock(capability, new IBlockCapabilityProvider<TApi, TContext>(this){

                @Nullable
                public TApi getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @Nullable TContext context) {
                    return blockEntity != null ? (Object)registration.provider.apply(blockEntity, context) : null;
                }
            }, blocks);
        }

        private <TApi, TContext> void doRegister(RegisterCapabilitiesEvent event, final BlockEntityFallbackProviderRegistration<TApi, TContext> registration) {
            BlockCapability capability = (BlockCapability)registration.type().backingType();
            Block[] blocks = (Block[])BuiltInRegistries.BLOCK_ENTITY_TYPE.stream().flatMap(it -> it.getValidBlocks().stream()).distinct().toArray(Block[]::new);
            event.registerBlock(capability, new IBlockCapabilityProvider<TApi, TContext>(this){

                @Nullable
                public TApi getCapability(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @Nullable TContext context) {
                    return blockEntity != null ? (Object)registration.provider.apply(blockEntity, context) : null;
                }
            }, blocks);
        }
    }

    record BlockEntityProviderRegistration<TApi, TContext>(CapabilityType<Block, TApi, TContext> type, BiFunction<BlockEntity, TContext, TApi> provider, Supplier<List<BlockEntityType<?>>> blockEntityTypes) {
    }

    record BlockEntityFallbackProviderRegistration<TApi, TContext>(CapabilityType<Block, TApi, TContext> type, BiFunction<BlockEntity, TContext, TApi> provider) {
    }
}

