/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.world.item.internal;

import java.util.function.Function;
import java.util.function.Supplier;
import net.blay09.mods.balm.core.BalmRegistrar;
import net.blay09.mods.balm.world.item.BalmItemRegistrar;
import net.blay09.mods.balm.world.item.BalmItemRegistration;
import net.blay09.mods.balm.world.item.DeferredItem;
import net.blay09.mods.balm.world.item.internal.DeferredItemImpl;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class BalmItemRegistrarImpl
implements BalmItemRegistrar {
    private final BalmRegistrar registrar;
    private final String namespace;

    public BalmItemRegistrarImpl(BalmRegistrar registrar, String namespace) {
        this.registrar = registrar;
        this.namespace = namespace;
    }

    @Override
    public BalmItemRegistration register(String name, Function<Item.Properties, Item> constructor, Supplier<Item.Properties> properties) {
        ResourceLocation identifier = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)name);
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)identifier);
        Holder<Item> holder = this.registrar.register(resourceKey, (ResourceLocation id) -> (Item)constructor.apply((Item.Properties)properties.get()));
        return new BalmItemRegistrationImpl(holder);
    }

    private static class BalmItemRegistrationImpl
    implements BalmItemRegistration {
        private final Holder<Item> holder;
        private DeferredItem deferredItem;

        private BalmItemRegistrationImpl(Holder<Item> holder) {
            this.holder = holder;
        }

        @Override
        public Holder<Item> asHolder() {
            return this.holder;
        }

        @Override
        public DeferredItem asDeferredItem() {
            if (this.deferredItem == null) {
                this.deferredItem = new DeferredItemImpl(this.holder);
            }
            return this.deferredItem;
        }
    }
}

