/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.entity.model;

import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class SacredPontiffModel
extends GeoModel<SacredPontiffEntity> {
    public ResourceLocation getModelResource(SacredPontiffEntity animatable) {
        if (animatable.getState() >= 5) {
            return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"geo/his_holiness.geo.json");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"geo/sacred_pontiff.geo.json");
    }

    public ResourceLocation getTextureResource(SacredPontiffEntity animatable) {
        if (animatable.getState() >= 5) {
            if (animatable.isDeadOrDying()) {
                int frames = 21;
                int perTick = 10;
                int frameIndex = animatable.deathTime / perTick % frames;
                return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)String.format("textures/entity/his_holiness_petrification%d.png", frameIndex));
            }
            return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)("textures/entity/his_holiness_" + animatable.tickCount / 2 % 10 + ".png"));
        }
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)("textures/entity/sacred_pontiff_" + animatable.tickCount / 2 % 5 + ".png"));
    }

    public ResourceLocation getAnimationResource(SacredPontiffEntity animatable) {
        if (animatable.getState() >= 5) {
            return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"animations/his_holiness.animation.json");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"animations/sacred_pontiff.animation.json");
    }

    public void setCustomAnimations(SacredPontiffEntity animatable, long instanceId, AnimationState<SacredPontiffEntity> animationState) {
        Entity camera;
        GeoBone head = this.getAnimationProcessor().getBone("head");
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (head != null && entityData != null) {
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * 0.5f * ((float)Math.PI / 180));
        }
        if ((camera = Minecraft.getInstance().getCameraEntity()) == null) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        Vec3 cameraPos = camera.getEyePosition(partialTick);
        Vec3 entityPos = animatable.getEyePosition(partialTick);
        Vec3 diff = new Vec3(cameraPos.x - entityPos.x, 0.0, cameraPos.z - entityPos.z).normalize();
        Vec3 view = animatable.getViewVector(partialTick).normalize();
        view = new Vec3(view.x, 0.0, view.z).normalize();
        Vec3 lateral = new Vec3(-view.z, 0.0, view.x);
        float dot = (float)(diff.x * lateral.x + diff.z * lateral.z);
        dot = Mth.clamp((float)dot, (float)-1.0f, (float)1.0f);
        GeoBone leftEyeBone = this.getAnimationProcessor().getBone("left_eye");
        GeoBone rightEyeBone = this.getAnimationProcessor().getBone("right_eye");
        float baseLeftEyeX = -0.0f;
        float baseRightEyeX = 0.0f;
        if (leftEyeBone != null) {
            leftEyeBone.setPosX(baseLeftEyeX - dot);
        }
        if (rightEyeBone != null) {
            rightEyeBone.setPosX(baseRightEyeX - dot);
        }
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
    }
}

