/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.companions.client.entity.model.CloakModel;
import dev.xylonity.companions.common.entity.companion.CloakEntity;
import dev.xylonity.companions.common.util.PhantomVisibility;
import dev.xylonity.companions.common.util.interfaces.IPhantomEffectEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class CloakRenderer
extends GeoEntityRenderer<CloakEntity> {
    public CloakRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CloakModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.shadowRadius = 1.0f;
    }

    public void render(@NotNull CloakEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        LocalPlayer player;
        IPhantomEffectEntity phantomEntity;
        if (entity instanceof IPhantomEffectEntity && (phantomEntity = (IPhantomEffectEntity)((Object)entity)).isPhantomEffectActive() && (player = Minecraft.getInstance().player) != null && this.getPhantomVisibility(entity, (Player)player) == PhantomVisibility.INVISIBLE) {
            return;
        }
        super.render((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public RenderType getRenderType(CloakEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        LocalPlayer player;
        IPhantomEffectEntity phantomEntity;
        if (animatable instanceof IPhantomEffectEntity && (phantomEntity = (IPhantomEffectEntity)((Object)animatable)).isPhantomEffectActive() && (player = Minecraft.getInstance().player) != null) {
            switch (this.getPhantomVisibility(animatable, (Player)player)) {
                case TRANSLUCENT: {
                    return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)animatable));
                }
                case INVISIBLE: {
                    return null;
                }
            }
        }
        return super.getRenderType((Entity)animatable, texture, bufferSource, partialTick);
    }

    public void actuallyRender(PoseStack poseStack, CloakEntity animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        LocalPlayer player;
        IPhantomEffectEntity phantomEntity;
        int a = colour >> 24 & 0xFF;
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        if (animatable instanceof IPhantomEffectEntity && (phantomEntity = (IPhantomEffectEntity)((Object)animatable)).isPhantomEffectActive() && (player = Minecraft.getInstance().player) != null) {
            PhantomVisibility visibility = this.getPhantomVisibility(animatable, (Player)player);
            if (visibility == PhantomVisibility.TRANSLUCENT) {
                a = Math.round(89.25f);
            } else if (visibility == PhantomVisibility.INVISIBLE) {
                return;
            }
        }
        int colour2 = a << 24 | r << 16 | g << 8 | b;
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour2);
    }

    private PhantomVisibility getPhantomVisibility(CloakEntity entity, Player clientPlayer) {
        IPhantomEffectEntity clientPhantom;
        IPhantomEffectEntity phantomEntity;
        if (!(entity instanceof IPhantomEffectEntity) || !(phantomEntity = (IPhantomEffectEntity)((Object)entity)).isPhantomEffectActive()) {
            return PhantomVisibility.NORMAL;
        }
        if (!(clientPlayer instanceof IPhantomEffectEntity) || !(clientPhantom = (IPhantomEffectEntity)clientPlayer).isPhantomEffectActive()) {
            return PhantomVisibility.INVISIBLE;
        }
        if (clientPlayer.getTeam() != null && clientPlayer.isAlliedTo((Entity)entity)) {
            return PhantomVisibility.TRANSLUCENT;
        }
        if (entity.getOwner() == clientPlayer) {
            return PhantomVisibility.TRANSLUCENT;
        }
        return PhantomVisibility.INVISIBLE;
    }
}

