/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xylonity.companions.client.projectile.model.BraceModel;
import dev.xylonity.companions.common.entity.projectile.BraceProjectile;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class BraceRenderer
extends GeoEntityRenderer<BraceProjectile> {
    public BraceRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new BraceModel());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BraceProjectile animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/brace.png");
    }

    public RenderType getRenderType(BraceProjectile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    protected void applyRotations(BraceProjectile animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        double pivotY = (double)animatable.getBbHeight() / 2.0;
        poseStack.translate(0.0, pivotY, 0.0);
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        float cameraYaw = camera.getYRot();
        float cameraPitch = camera.getXRot();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - cameraYaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(-cameraPitch));
        poseStack.translate(0.0, -pivotY, 0.0);
        super.applyRotations((Entity)animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
    }

    public void actuallyRender(PoseStack poseStack, BraceProjectile animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.scale(0.75f, 0.75f, 0.75f);
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }
}

