/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.block;

import com.mojang.serialization.MapCodec;
import dev.xylonity.companions.registry.CompanionsParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EternalFireBlock
extends BaseFireBlock {
    public static final MapCodec<EternalFireBlock> CODEC = EternalFireBlock.simpleCodec(EternalFireBlock::new);

    public EternalFireBlock(BlockBehaviour.Properties properties) {
        super(properties, 2.0f);
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        return this.canSurvive(state, (LevelReader)level, pos) ? this.defaultBlockState() : Blocks.AIR.defaultBlockState();
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return true;
    }

    protected boolean canBurn(@NotNull BlockState state) {
        return true;
    }

    protected MapCodec<? extends BaseFireBlock> codec() {
        return CODEC;
    }

    public void animateTick(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource randomSource) {
        double z;
        double y;
        double x;
        super.animateTick(blockState, level, pos, randomSource);
        if (level.random.nextFloat() < 0.35f) {
            x = (double)pos.getX() + randomSource.nextDouble();
            y = (double)pos.getY() + randomSource.nextDouble();
            z = (double)pos.getZ() + randomSource.nextDouble();
            level.addParticle((ParticleOptions)CompanionsParticles.HOLINESS_BLUE_STAR_TRAIL.get(), x, y, z, 0.0, 0.0, 0.0);
        }
        if (level.random.nextFloat() < 0.35f) {
            x = (double)pos.getX() + randomSource.nextDouble();
            y = (double)pos.getY() + randomSource.nextDouble();
            z = (double)pos.getZ() + randomSource.nextDouble();
            level.addParticle((ParticleOptions)CompanionsParticles.HOLINESS_RED_STAR_TRAIL.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

