/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.block.SoulFurnaceBlock;
import dev.xylonity.companions.common.container.SoulFurnaceContainerMenu;
import dev.xylonity.companions.common.recipe.SoulFurnaceRecipe;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsRecipes;
import dev.xylonity.knightlib.common.blockentity.GreatChaliceBlockEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class SoulFurnaceBlockEntity
extends BlockEntity
implements GeoBlockEntity,
MenuProvider,
Container {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private NonNullList<ItemStack> items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private static final int MAX_CHARGES = 9;
    public int charges = 0;
    private int currentProgress = 0;
    private int processingTime = 0;
    @Nullable
    private SoulFurnaceRecipe currentRecipe = null;
    public boolean isLit = false;

    public SoulFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(CompanionsBlockEntities.SOUL_FURNACE.get(), pos, state);
    }

    public boolean canPlaceItem(int pIndex, @NotNull ItemStack pStack) {
        return pIndex == 0;
    }

    public boolean canTakeItem(@NotNull Container pTarget, int pIndex, @NotNull ItemStack pStack) {
        return pIndex == 1;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        ItemStack inputStack;
        SoulFurnaceRecipe found;
        SoulFurnaceBlockEntity furnace;
        block8: {
            block7: {
                if (!(be instanceof SoulFurnaceBlockEntity)) break block7;
                furnace = (SoulFurnaceBlockEntity)be;
                if (!level.isClientSide()) break block8;
            }
            return;
        }
        furnace.handleGreatChaliceInteraction(level, pos);
        if (furnace.currentRecipe == null && !furnace.getItem(0).isEmpty() && (found = furnace.findRecipe(level, inputStack = furnace.getItem(0))) != null) {
            inputStack.shrink(1);
            furnace.currentRecipe = found;
            furnace.processingTime = found.processTime();
            furnace.currentProgress = 0;
            furnace.setChanged();
        }
        if (furnace.currentRecipe != null) {
            furnace.handleCooking(pos, level, state);
        }
        boolean lit = furnace.currentRecipe != null;
        BlockState currentState = level.getBlockState(pos);
        if (currentState.hasProperty((Property)SoulFurnaceBlock.LIT) && (Boolean)currentState.getValue((Property)SoulFurnaceBlock.LIT) != lit) {
            level.setBlock(pos, (BlockState)currentState.setValue((Property)SoulFurnaceBlock.LIT, (Comparable)Boolean.valueOf(lit)), 3);
        }
        if (CompanionsConfig.SOUL_FURNACE_CONSTANT_MAX_CHARGES) {
            furnace.charges = 9;
        }
    }

    private void handleGreatChaliceInteraction(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos.above());
        if (blockEntity instanceof GreatChaliceBlockEntity) {
            GreatChaliceBlockEntity be = (GreatChaliceBlockEntity)blockEntity;
            if (this.charges < 9 && be.isFull()) {
                be.setCharges(0);
                level.playSound(null, pos.above(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.charges = Math.min(this.charges + 1, 9);
                this.setChanged();
            }
        }
    }

    private void handleCooking(BlockPos pos, Level level, BlockState state) {
        SoulFurnaceRecipe next;
        ++this.currentProgress;
        if (this.currentRecipe == null) {
            return;
        }
        if (this.currentProgress < this.processingTime) {
            return;
        }
        SoulFurnaceRecipe recipe = this.currentRecipe;
        level.playSound(null, pos.above(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (recipe.outputsItem()) {
            ItemStack output = new ItemStack((ItemLike)recipe.resultItem(), Math.max(1, recipe.resultCount()));
            ItemStack current = this.getItem(1);
            if (current.isEmpty()) {
                this.setItem(1, output);
            } else if (ItemStack.isSameItem((ItemStack)current, (ItemStack)output) || current.is(output.getItem())) {
                current.grow(output.getCount());
            } else {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)output);
            }
        } else if (recipe.outputsEntity()) {
            BlockPos spawnPos = pos.relative((Direction)state.getValue((Property)SoulFurnaceBlock.FACING));
            Entity e = recipe.resultEntity().create(level);
            if (e != null) {
                e.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                level.addFreshEntity(e);
            }
        } else if (recipe.outputsBlock()) {
            Block target = recipe.resultBlock();
            BlockPos targetPos = pos.relative((Direction)state.getValue((Property)SoulFurnaceBlock.FACING));
            if (level.isEmptyBlock(targetPos)) {
                BlockState recipeState = target.defaultBlockState();
                if (recipeState.hasProperty((Property)SoulFurnaceBlock.FACING)) {
                    recipeState = (BlockState)recipeState.setValue((Property)SoulFurnaceBlock.FACING, (Comparable)((Direction)state.getValue((Property)SoulFurnaceBlock.FACING)));
                } else if (recipeState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    recipeState = (BlockState)recipeState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)SoulFurnaceBlock.FACING)));
                }
                level.setBlockAndUpdate(targetPos, recipeState);
                this.spawnPoofParticles(targetPos);
            } else if (level.getBlockState(targetPos).getBlock() == target) {
                BlockPos stackPos = targetPos;
                while (!level.isEmptyBlock(stackPos) && stackPos.getY() < level.getMaxBuildHeight()) {
                    stackPos = stackPos.above();
                }
                if (level.isEmptyBlock(stackPos)) {
                    level.setBlockAndUpdate(stackPos, target.defaultBlockState());
                } else {
                    Containers.dropItemStack((Level)level, (double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ(), (ItemStack)new ItemStack((ItemLike)target));
                }
            } else {
                Containers.dropItemStack((Level)level, (double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ(), (ItemStack)new ItemStack((ItemLike)target));
            }
        }
        this.charges -= recipe.requiredCharges();
        this.currentRecipe = null;
        this.currentProgress = 0;
        this.processingTime = 0;
        this.setChanged();
        ItemStack stack = this.getItem(0);
        if (!stack.isEmpty() && (next = this.findRecipe(level, stack)) != null) {
            stack.shrink(1);
            this.currentRecipe = next;
            this.processingTime = next.processTime();
            this.currentProgress = 0;
            this.setChanged();
        }
    }

    @Nullable
    private SoulFurnaceRecipe findRecipe(Level level, ItemStack input) {
        if (input.isEmpty()) {
            return null;
        }
        List list = level.getRecipeManager().getAllRecipesFor(CompanionsRecipes.SOUL_FURNACE_TYPE.get());
        for (RecipeHolder rec : list) {
            SoulFurnaceRecipe r;
            Recipe recipe = rec.value();
            if (!(recipe instanceof SoulFurnaceRecipe) || !(r = (SoulFurnaceRecipe)recipe).input().test(input) || this.charges < r.requiredCharges()) continue;
            return r;
        }
        return null;
    }

    private void spawnPoofParticles(BlockPos targetPos) {
        for (int i = 0; i < 25; ++i) {
            double dx = (new Random().nextDouble() - 0.5) * 2.5;
            double dy = (new Random().nextDouble() - 0.5) * 1.5;
            double dz = (new Random().nextDouble() - 0.5) * 2.5;
            Level level = this.level;
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, (double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ(), 1, dx, dy, dz, 0.04);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.charges = tag.getInt("Charges");
        this.currentProgress = tag.getInt("Progress");
        this.processingTime = tag.getInt("ProcessingTime");
        this.items = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("Charges", this.charges);
        tag.putInt("Progress", this.currentProgress);
        tag.putInt("ProcessingTime", this.processingTime);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)provider);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.literal((String)"Soul Furnace");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new SoulFurnaceContainerMenu(id, inventory, this, new ContainerData(){

            public int get(int index) {
                if (index == 0) {
                    return SoulFurnaceBlockEntity.this.charges;
                }
                if (index == 1) {
                    return SoulFurnaceBlockEntity.this.currentProgress;
                }
                if (index == 2) {
                    return SoulFurnaceBlockEntity.this.processingTime;
                }
                return 0;
            }

            public void set(int index, int value) {
                if (index == 0) {
                    SoulFurnaceBlockEntity.this.charges = value;
                } else if (index == 1) {
                    SoulFurnaceBlockEntity.this.currentProgress = value;
                } else if (index == 2) {
                    SoulFurnaceBlockEntity.this.processingTime = value;
                }
            }

            public int getCount() {
                return 3;
            }
        });
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int index) {
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack removeItem(int index, int count) {
        return ContainerHelper.removeItem(this.items, (int)index, (int)count);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public void setItem(int index, @NotNull ItemStack stack) {
        SoulFurnaceRecipe found;
        if (index == 0 && !stack.isEmpty() && this.currentRecipe == null && this.level != null && !this.level.isClientSide() && (found = this.findRecipe(this.level, stack)) != null) {
            stack.shrink(1);
            this.currentRecipe = found;
            this.processingTime = found.processTime();
            this.currentProgress = 0;
            this.setChanged();
        }
        this.items.set(index, (Object)stack);
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
    }

    public static int getMaxCharges() {
        return 9;
    }

    public boolean isLit() {
        return this.isLit;
    }
}

