/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.antlion.tamable.goal;

import dev.xylonity.companions.common.entity.ai.antlion.tamable.AbstractAntlionAttackGoal;
import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import dev.xylonity.companions.common.entity.projectile.AntlionSandProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class AntlionSoldierLongAttackGoal
extends AbstractAntlionAttackGoal {
    public AntlionSoldierLongAttackGoal(AntlionEntity antlion, int minCd, int maxCd) {
        super(antlion, 35, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.antlion.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.antlion.setNoMovement(false);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.antlion.getTarget() != null && this.antlion.distanceToSqr((Entity)this.antlion.getTarget()) <= 225.0 && this.antlion.distanceToSqr((Entity)this.antlion.getTarget()) >= 9.0;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        AntlionSandProjectile projectile = (AntlionSandProjectile)CompanionsEntities.ANTLION_SAND_PROJECTILE.get().create(this.antlion.level());
        if (projectile != null) {
            Vec3 basePos = this.antlion.position().add(0.0, (double)(this.antlion.getBbHeight() * 0.5f), 0.0);
            Vec3 targetPos = target.position().add(0.0, (double)target.getEyeHeight(), 0.0);
            Vec3 dir = targetPos.subtract(basePos).normalize();
            Vec3 spawnPos = basePos.add(new Vec3(-dir.z, 0.0, dir.x).normalize().scale((double)(-0.5f + this.antlion.level().random.nextFloat())));
            projectile.setOwner((Entity)this.antlion);
            projectile.setTarget(target);
            projectile.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            projectile.setDeltaMovement(targetPos.subtract(spawnPos).normalize().scale((double)projectile.getDefaultSpeed()));
            projectile.setNoGravity(true);
            this.antlion.level().addFreshEntity((Entity)projectile);
        }
        this.antlion.playSound(CompanionsSounds.SOLDIER_ANTLION_SAND_CANNON.get());
    }

    @Override
    protected int attackDelay() {
        return 11;
    }

    @Override
    protected int attackType() {
        return 2;
    }

    @Override
    protected int variant() {
        return 3;
    }
}

