/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.antlion.wild.goal;

import dev.xylonity.companions.common.entity.hostile.WildAntlionEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class WildAntlionNearestAttackableTarget<T extends LivingEntity>
extends TargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    protected final Class<T> targetType;
    protected final int randomInterval;
    protected LivingEntity target;
    protected TargetingConditions targetConditions;
    private final WildAntlionEntity antlion;

    public WildAntlionNearestAttackableTarget(WildAntlionEntity pMob, Class<T> pTargetType, boolean pMustSee) {
        this(pMob, pTargetType, 10, pMustSee, false, null);
    }

    public WildAntlionNearestAttackableTarget(WildAntlionEntity pMob, Class<T> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<LivingEntity> pTargetPredicate) {
        super((Mob)pMob, pMustSee, pMustReach);
        this.targetType = pTargetType;
        this.randomInterval = WildAntlionNearestAttackableTarget.reducedTickDelay((int)pRandomInterval);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.antlion = pMob;
        this.targetConditions = TargetingConditions.forCombat().range(this.getFollowDistance()).selector(pTargetPredicate);
    }

    public boolean canUse() {
        if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && this.isValidTarget(this.target);
    }

    public void start() {
        this.mob.setTarget(this.target);
        super.start();
    }

    public void setTarget(@Nullable LivingEntity pTarget) {
        this.target = pTarget;
    }

    protected AABB getTargetSearchArea(double pTargetDistance) {
        return this.mob.getBoundingBox().inflate(pTargetDistance, 4.0, pTargetDistance);
    }

    protected void findTarget() {
        this.target = this.mob.level().getEntitiesOfClass(this.targetType, this.getTargetSearchArea(this.getFollowDistance()), e -> true).stream().filter(this::isValidTarget).min(Comparator.comparingDouble(e -> e.distanceToSqr(this.mob.getX(), this.mob.getY(), this.mob.getZ()))).orElse(null);
    }

    public void tick() {
        if (this.target != null) {
            this.antlion.lookAt((Entity)this.target, 30.0f, 30.0f);
        }
    }

    private boolean isValidTarget(LivingEntity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        Player p = (Player)e;
        if (p.isCreative() || p.isSpectator()) {
            return false;
        }
        if (!this.antlion.hasLineOfSight((Entity)p)) {
            return false;
        }
        return !(this.antlion.getLookAngle().normalize().dot(p.position().subtract(this.antlion.position()).normalize()) < 0.0) || !p.isShiftKeyDown();
    }
}

