/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cloak.goal;

import dev.xylonity.companions.common.entity.ai.cloak.AbstractCloakAttackGoal;
import dev.xylonity.companions.common.entity.companion.CloakEntity;
import dev.xylonity.companions.registry.CompanionsEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CloakInvisibilityGoal
extends AbstractCloakAttackGoal {
    public CloakInvisibilityGoal(CloakEntity cloak, int minCd, int maxCd) {
        super(cloak, 25, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.cloak.setNoMovement(true);
    }

    @Override
    public void stop() {
        super.stop();
        this.cloak.setNoMovement(false);
    }

    @Override
    public boolean canUse() {
        if (this.cloak.getAttackType() != 0) {
            return false;
        }
        if (this.cloak.getMainAction() != 1) {
            return false;
        }
        if (this.cloak.getOwner() == null) {
            return false;
        }
        if (this.cloak.getOwner().hasEffect(CompanionsEffects.PHANTOM)) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.cloak.tickCount + this.minCooldown + this.cloak.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.cloak.tickCount >= this.nextUseTick;
    }

    @Override
    public void tick() {
        LivingEntity target = this.cloak.getTarget();
        if (target != null) {
            this.cloak.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && this.cloak.getOwner() != null && this.cloak.getOwner().isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        if (this.cloak.getOwner() != null) {
            this.cloak.getOwner().addEffect(new MobEffectInstance(CompanionsEffects.PHANTOM, 600, 0, false, true, true));
            this.cloak.addEffect(new MobEffectInstance(CompanionsEffects.PHANTOM, 600, 0, false, true, true));
            this.spawnParticles(this.cloak.getOwner().position(), this.cloak.getOwner().getBbHeight());
            this.spawnParticles(this.cloak.position(), this.cloak.getBbHeight());
        }
    }

    private void spawnParticles(Vec3 pos, float entityHeight) {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.cloak.level().random.nextDouble() - 0.5) * 0.75;
            double dy = (this.cloak.level().random.nextDouble() - 0.5) * 0.75;
            double dz = (this.cloak.level().random.nextDouble() - 0.5) * 0.75;
            Level level = this.cloak.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, pos.x, pos.y + (double)(entityHeight * 0.5f), pos.z, 1, dx, dy, dz, 0.1);
        }
    }

    @Override
    protected int attackDelay() {
        return 20;
    }

    @Override
    protected int attackType() {
        return 3;
    }
}

