/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.goal;

import dev.xylonity.companions.common.entity.ai.cornelius.AbstractCorneliusAttackGoal;
import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class CorneliusAttackBeeGoal
extends AbstractCorneliusAttackGoal {
    private boolean shouldTame = false;

    public CorneliusAttackBeeGoal(CorneliusEntity cornelius, int minCd, int maxCd) {
        super(cornelius, minCd, maxCd);
    }

    @Override
    public boolean canUse() {
        if (this.cornelius.isTame()) {
            return false;
        }
        if (this.cornelius.level().getEntitiesOfClass(Player.class, this.cornelius.getBoundingBox().inflate(10.0)).isEmpty()) {
            return false;
        }
        if (this.cornelius.getAttackType() != 0) {
            return false;
        }
        if (this.cornelius.getTarget() == null) {
            return false;
        }
        if (this.cornelius.distanceToSqr((Entity)this.cornelius.getTarget()) >= 9.0) {
            return false;
        }
        if (this.nextUseTick < 0) {
            int cd = this.minCooldown + this.cornelius.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            this.nextUseTick = this.cornelius.tickCount + cd;
            return false;
        }
        return this.cornelius.tickCount >= this.nextUseTick;
    }

    @Override
    public void start() {
        int currentAttackType = this.cornelius.getRandom().nextInt(2) + 2;
        if (currentAttackType == 2) {
            this.currentAttackDelay = 17;
            this.currentAttackDuration = 25;
        } else {
            this.currentAttackDelay = 18;
            this.currentAttackDuration = 26;
        }
        this.attackTicks = 0;
        this.started = true;
        this.cornelius.setAttackType(currentAttackType);
        this.cornelius.playSound(CompanionsSounds.FROGGY_ATTACK.get());
    }

    @Override
    protected void performAttack(LivingEntity target) {
        if (target != null && this.cornelius.distanceToSqr((Entity)target) <= 9.0) {
            target.kill();
            this.shouldTame = true;
        }
    }

    @Override
    public void stop() {
        Player player;
        super.stop();
        if (this.shouldTame && (player = this.cornelius.level().getNearestPlayer((Entity)this.cornelius, 16.0)) != null) {
            this.cornelius.tameInteraction(player);
            this.generatePoofParticles();
        }
    }

    @Override
    protected Item coin() {
        return null;
    }

    @Override
    protected int coinsToConsume() {
        return 0;
    }

    private void generatePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double dx = (this.cornelius.level().random.nextDouble() - 0.5) * 1.25;
            double dy = (this.cornelius.level().random.nextDouble() - 0.5) * 1.25;
            double dz = (this.cornelius.level().random.nextDouble() - 0.5) * 1.25;
            Level level = this.cornelius.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.cornelius.position().x, this.cornelius.getY() + (double)this.cornelius.getBbHeight() * Math.random(), this.cornelius.position().z, 1, dx, dy, dz, 0.1);
        }
    }
}

