/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.goal;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.common.util.interfaces.IFrogJumpUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.pathfinder.PathType;

public class HopToOwnerGoal<T extends CompanionEntity>
extends CompanionFollowOwnerGoal {
    private int cycleCounter = 0;

    public HopToOwnerGoal(T pTamable, double pSpeedModifier, float pStartDistance, float pStopDistance, boolean pCanFly) {
        super((CompanionEntity)((Object)pTamable), pSpeedModifier, pStartDistance, pStopDistance, pCanFly);
    }

    @Override
    public boolean canUse() {
        LivingEntity owner = this.tamable.getOwner();
        if (this.tamable.getMainAction() != 1) {
            return false;
        }
        if (((IFrogJumpUtil)((Object)this.tamable)).getAttackType() != 0) {
            return false;
        }
        if (owner == null) {
            return false;
        }
        if (owner.isSpectator()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.tamable.distanceToSqr((Entity)owner) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.getPathfindingMalus(PathType.WATER);
        ((IFrogJumpUtil)((Object)this.tamable)).setCanAttack(false);
    }

    @Override
    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.tamable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        ((IFrogJumpUtil)((Object)this.tamable)).setCanAttack(true);
    }

    @Override
    public void tick() {
        this.tamable.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.tamable.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (this.tamable.distanceToSqr((Entity)this.owner) >= (double)(TELEPORT_WHEN_DISTANCE_IS * TELEPORT_WHEN_DISTANCE_IS)) {
                this.teleportToOwner();
            } else {
                if (((CorneliusEntity)this.tamable).getCycleCount() == -1) {
                    ((CorneliusEntity)this.tamable).setCycleCount(((CorneliusEntity)this.tamable).getCycleCount() + 1);
                }
                this.navigation.moveTo((Entity)this.owner, this.speedModifier);
            }
        }
    }
}

