/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon.goal;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.AbstractCorneliusSummonAttackGoal;
import dev.xylonity.companions.common.entity.projectile.FrogHealProjectile;
import dev.xylonity.companions.common.entity.summon.EnderFrogEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class EnderFrogHealGoal
extends AbstractCorneliusSummonAttackGoal {
    public EnderFrogHealGoal(CompanionSummonEntity summon, int minCd, int maxCd) {
        super(summon, 30, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.summon.setNoMovement(true);
        this.summon.playSound(CompanionsSounds.SPELL_RELEASE_HEAL.get());
    }

    @Override
    public boolean canUse() {
        if (((Object)((Object)this.summon)).getClass() != this.summonType()) {
            return false;
        }
        if (this.summon.getAttackType() != 0) {
            return false;
        }
        if (this.summon.getSecondOwner() != null ? this.summon.getOwner() != null && this.summon.getOwner().getHealth() >= this.summon.getOwner().getMaxHealth() * 0.5f && this.summon.getSecondOwner().getHealth() >= this.summon.getSecondOwner().getMaxHealth() * 0.5f : this.summon.getOwner() != null && this.summon.getOwner().getHealth() >= this.summon.getOwner().getMaxHealth() * 0.5f) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.summon.tickCount + this.minCooldown + this.summon.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.summon.tickCount >= this.nextUseTick;
    }

    @Override
    public void stop() {
        super.stop();
        this.summon.setNoMovement(false);
    }

    @Override
    public void tick() {
        LivingEntity owner = null;
        if (this.summon.getOwner() != null && this.summon.getOwner().getHealth() < this.summon.getOwner().getMaxHealth() * 0.5f) {
            owner = this.summon.getOwner();
        }
        if (this.summon.getSecondOwner() != null && this.summon.getSecondOwner().getHealth() < this.summon.getSecondOwner().getMaxHealth() * 0.5f) {
            owner = this.summon.getSecondOwner();
        }
        if (owner != null) {
            this.summon.getLookControl().setLookAt(owner, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && owner != null && owner.isAlive()) {
            this.performAttack(owner);
        }
        ++this.attackTicks;
    }

    @Override
    protected int getAttackType() {
        return 1;
    }

    @Override
    protected void performAttack(LivingEntity owner) {
        FrogHealProjectile projectile = (FrogHealProjectile)CompanionsEntities.FROG_HEAL_PROJECTILE.get().create(this.summon.level());
        if (projectile != null) {
            Vec3 targetPos = owner.position().add(0.0, (double)owner.getEyeHeight(), 0.0);
            Vec3 spawnPos = this.summon.position().add(0.0, (double)this.summon.getBbHeight() * 1.25, 0.0);
            Vec3 vel = targetPos.subtract(spawnPos).normalize().scale((double)projectile.getDefaultSpeed());
            projectile.setOwner((Entity)this.summon);
            projectile.setTarget(owner);
            projectile.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            projectile.setDeltaMovement(vel);
            projectile.setNoGravity(true);
            this.summon.level().addFreshEntity((Entity)projectile);
        }
    }

    @Override
    protected int attackDelay() {
        return 17;
    }

    @Override
    protected Class<? extends CompanionSummonEntity> summonType() {
        return EnderFrogEntity.class;
    }
}

