/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon.goal;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.summon.AbstractCorneliusSummonAttackGoal;
import dev.xylonity.companions.common.entity.summon.FireworkToadEntity;
import dev.xylonity.companions.common.util.Util;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireworkToadGoal
extends AbstractCorneliusSummonAttackGoal {
    private Vec3 p0;
    private Vec3 p1;
    private Vec3 p2;
    private int totalTicks;
    private boolean flying;

    public FireworkToadGoal(CompanionSummonEntity summon, int minCd, int maxCd) {
        super(summon, 110, minCd, maxCd);
    }

    @Override
    public boolean canUse() {
        return super.canUse();
    }

    @Override
    public void start() {
        super.start();
        FireworkToadEntity toad = (FireworkToadEntity)this.summon;
        LivingEntity target = toad.getTarget();
        if (target == null || !target.isAlive()) {
            return;
        }
        this.p0 = toad.position();
        this.p2 = target.position();
        double horiz = new Vec3(this.p2.x - this.p0.x, 0.0, this.p2.z - this.p0.z).length();
        double y = Math.max(this.p0.y, this.p2.y) + Mth.clamp((double)(horiz * 1.15), (double)1.0, (double)12.0);
        this.p1 = new Vec3((this.p0.x + this.p2.x) * 0.5, y, (this.p0.z + this.p2.z) * 0.5);
        this.totalTicks = new Random().nextInt(70, 110);
        this.flying = true;
        toad.setFlying(true);
        toad.setNoMovement(true);
        toad.setNoGravity(true);
        toad.noPhysics = true;
        toad.getNavigation().stop();
        toad.setDeltaMovement(Vec3.ZERO);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.flying) {
            return;
        }
        Vec3 pos = Util.bezier(this.p0, this.p1, this.p2, (double)this.attackTicks / (double)this.totalTicks);
        this.summon.setPos(pos.x, pos.y, pos.z);
        this.summon.setDeltaMovement(Vec3.ZERO);
        Vec3 dir = Util.bezier(this.p0, this.p1, this.p2, Math.min((double)this.attackTicks / (double)this.totalTicks + 0.01, 1.0)).subtract(pos).normalize();
        float yaw = (float)(Mth.atan2((double)dir.z, (double)dir.x) * 180.0 / Math.PI) - 90.0f;
        this.summon.setYRot(yaw);
        this.summon.setYBodyRot(yaw);
        this.summon.setXRot((float)(-Mth.atan2((double)dir.y, (double)Math.sqrt(dir.x * dir.x + dir.z * dir.z)) * 180.0 / Math.PI));
        ++this.attackTicks;
        if (this.attackTicks >= this.totalTicks) {
            this.spawnRockets(pos);
            FireworkToadGoal.resetPhysics((FireworkToadEntity)this.summon);
            this.summon.remove(Entity.RemovalReason.DISCARDED);
            this.flying = false;
        }
        if (this.attackTicks == this.totalTicks / 2) {
            this.summon.triggerAnim("rot_controller", "rot");
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.flying && this.summon.isAlive()) {
            FireworkToadGoal.resetPhysics((FireworkToadEntity)this.summon);
        }
        this.flying = false;
    }

    @Override
    protected void performAttack(LivingEntity owner) {
    }

    private static void resetPhysics(FireworkToadEntity toad) {
        toad.setFlying(false);
        toad.setNoMovement(false);
        toad.setNoGravity(false);
        toad.noPhysics = false;
        toad.setDeltaMovement(Vec3.ZERO);
        toad.setParabolaCenter(null);
    }

    private void spawnRockets(Vec3 center) {
        Level level = this.summon.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.FLASH, center.x, center.y, center.z, 1, 0.0, 0.0, 0.0, 0.0);
            for (int i = 0; i < 6; ++i) {
                double angle = this.summon.getRandom().nextDouble() * Math.PI * 2.0;
                double dist = this.summon.getRandom().nextDouble() * 8.0;
                double dx = Math.cos(angle) * dist;
                double dz = Math.sin(angle) * dist;
                double dy = 3.0 + this.summon.getRandom().nextDouble() * 7.0;
                FireworkToadGoal.rocket(level2, new Vec3(center.x + dx, center.y + dy, center.z + dz), this.summon.getRandom());
            }
            FireworkToadGoal.rocket(level2, new Vec3(center.x, center.y + 0.5, center.z), this.summon.getRandom());
            for (LivingEntity e : level2.getEntitiesOfClass(LivingEntity.class, this.summon.getBoundingBox().inflate(3.0))) {
                if (Util.areEntitiesLinked((Entity)e, (Entity)this.summon)) continue;
                this.summon.doHurtTarget((Entity)e);
            }
        }
    }

    private static void rocket(ServerLevel world, Vec3 where, RandomSource r) {
        double rand = r.nextDouble();
        FireworkExplosion.Shape shape = rand < 0.3 ? (r.nextBoolean() ? FireworkExplosion.Shape.SMALL_BALL : FireworkExplosion.Shape.LARGE_BALL) : (rand < 0.6 ? FireworkExplosion.Shape.STAR : FireworkExplosion.Shape.BURST);
        int cr = 128 + r.nextInt(128);
        int cg = 128 + r.nextInt(128);
        int cb = 128 + r.nextInt(128);
        int color = cr << 16 | cg << 8 | cb;
        IntArrayList colors = new IntArrayList(new int[]{color});
        IntArrayList fades = new IntArrayList(new int[]{color});
        ItemStack stack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        stack.set(DataComponents.FIREWORKS, (Object)new Fireworks(1, List.of(new FireworkExplosion(shape, (IntList)colors, (IntList)fades, false, true))));
        FireworkRocketEntity rocket = new FireworkRocketEntity((Level)world, where.x, where.y, where.z, stack);
        world.addFreshEntity((Entity)rocket);
        world.broadcastEntityEvent((Entity)rocket, (byte)17);
        rocket.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    protected int getAttackType() {
        return 1;
    }

    @Override
    protected int attackDelay() {
        return -1;
    }

    @Override
    protected Class<? extends CompanionSummonEntity> summonType() {
        return FireworkToadEntity.class;
    }
}

