/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius.summon.goal;

import dev.xylonity.companions.common.entity.CompanionSummonEntity;
import dev.xylonity.companions.common.entity.SummonFrogEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionSummonFollowOwnerGoal;
import dev.xylonity.companions.common.util.interfaces.IFrogJumpUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.pathfinder.PathType;

public class SummonHopToOwnerGoal<T extends CompanionSummonEntity>
extends CompanionSummonFollowOwnerGoal {
    private int cycleCounter = 0;

    public SummonHopToOwnerGoal(T pTamable, double pSpeedModifier, float pStartDistance, float pStopDistance, boolean pCanFly) {
        super((CompanionSummonEntity)((Object)pTamable), pSpeedModifier, pStartDistance, pStopDistance, pCanFly);
    }

    @Override
    public boolean canUse() {
        LivingEntity owner = this.tamable.getOwner();
        if (((IFrogJumpUtil)((Object)this.tamable)).getAttackType() != 0) {
            return false;
        }
        if (owner == null) {
            return false;
        }
        if (owner.isSpectator()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.tamable.distanceToSqr((Entity)owner) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.getPathfindingMalus(PathType.WATER);
        ((IFrogJumpUtil)((Object)this.tamable)).setCanAttack(false);
    }

    @Override
    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.tamable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        ((IFrogJumpUtil)((Object)this.tamable)).setCanAttack(true);
    }

    @Override
    public void tick() {
        this.tamable.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.tamable.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (this.tamable.distanceToSqr((Entity)this.owner) >= (double)(TELEPORT_WHEN_DISTANCE_IS * TELEPORT_WHEN_DISTANCE_IS)) {
                this.teleportToOwner();
            } else {
                if (((SummonFrogEntity)this.tamable).getCycleCount() == -1) {
                    ((SummonFrogEntity)this.tamable).setCycleCount(((SummonFrogEntity)this.tamable).getCycleCount() + 1);
                }
                this.navigation.moveTo((Entity)this.owner, this.speedModifier);
            }
        }
        ++this.cycleCounter;
        if (this.cycleCounter >= 20) {
            this.cycleCounter = 0;
        }
    }
}

