/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.croissant;

import dev.xylonity.companions.common.entity.companion.CroissantDragonEntity;
import dev.xylonity.companions.common.entity.projectile.trigger.CakeCreamTriggerProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CroissantDragonAttackGoal
extends Goal {
    private final CroissantDragonEntity dragon;
    private int tickCount;
    private int cooldown = 0;
    private int attacksOnSameTarget = 0;
    private LivingEntity lastTarget;

    public CroissantDragonAttackGoal(CroissantDragonEntity dragon) {
        this.dragon = dragon;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        LivingEntity target = this.dragon.getTarget();
        return target != null && target.isAlive();
    }

    public boolean canContinueToUse() {
        return this.tickCount < 25 && this.dragon.getTarget() != null && this.dragon.getTarget().isAlive();
    }

    public void start() {
        this.tickCount = 0;
        this.dragon.setAttacking(true);
        TickScheduler.scheduleServer((Level)this.dragon.level(), () -> this.dragon.setAttacking(false), (int)50);
        LivingEntity currentTarget = this.dragon.getTarget();
        if (!(currentTarget == null || this.lastTarget != null && this.lastTarget.equals((Object)currentTarget))) {
            this.lastTarget = currentTarget;
            this.attacksOnSameTarget = 0;
        }
    }

    public void tick() {
        ++this.tickCount;
        LivingEntity target = this.dragon.getTarget();
        if (target != null) {
            this.dragon.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            double dx = target.getX() - this.dragon.getX();
            double dz = target.getZ() - this.dragon.getZ();
            float angle = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            this.dragon.setYRot(angle);
            this.dragon.yBodyRot = angle;
            this.dragon.yHeadRot = angle;
            this.dragon.yRotO = angle;
            this.dragon.yBodyRotO = angle;
            this.dragon.yHeadRotO = angle;
        }
        if (this.tickCount >= 5) {
            if (this.tickCount == 5) {
                this.dragon.playSound(CompanionsSounds.CROISSANT_DRAGON_BREATH.get(), 1.5f, 1.0f);
            }
            Vec3 eyePos = new Vec3(this.dragon.getX(), this.dragon.getY() + (double)this.dragon.getEyeHeight() * 0.2, this.dragon.getZ());
            Vec3 viewVector = this.dragon.getViewVector(1.0f).normalize();
            Vec3 spawnPos = eyePos.add(viewVector.scale(1.0));
            this.dragon.setStoredViewVector(viewVector);
            Level angle = this.dragon.level();
            if (angle instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)angle;
                SimpleParticleType particle = this.dragon.getArmorName().equals("chocolate") ? CompanionsParticles.CAKE_CREAM_CHOCOLATE.get() : (this.dragon.getArmorName().equals("strawberry") ? CompanionsParticles.CAKE_CREAM_STRAWBERRY.get() : CompanionsParticles.CAKE_CREAM.get());
                level.sendParticles((ParticleOptions)particle, spawnPos.x, spawnPos.y, spawnPos.z, 12, 0.0, 0.0, 0.0, 0.0);
            }
            if (!this.dragon.level().isClientSide() && this.tickCount % 2 == 0) {
                CakeCreamTriggerProjectile projectile = new CakeCreamTriggerProjectile(CompanionsEntities.CAKE_CREAM_TRIGGER_PROJECTILE.get(), this.dragon.level());
                projectile.setPos(spawnPos.x, spawnPos.y + new Random().nextDouble(0.0, 1.0), spawnPos.z);
                projectile.setArmorName(this.dragon.getArmorName());
                projectile.setOwner((Entity)this.dragon);
                projectile.setDeltaMovement(Util.randomVectorInCone(viewVector, 15.0, new Random()).scale(0.5 * (0.8 + new Random().nextDouble() * 0.4)));
                this.dragon.level().addFreshEntity((Entity)projectile);
            }
        }
    }

    public void stop() {
        LivingEntity currentTarget = this.dragon.getTarget();
        if (currentTarget != null) {
            if (this.lastTarget != null && this.lastTarget.equals((Object)currentTarget)) {
                ++this.attacksOnSameTarget;
            } else {
                this.lastTarget = currentTarget;
                this.attacksOnSameTarget = 1;
            }
            if (this.attacksOnSameTarget >= 3) {
                this.dragon.setTarget(null);
                this.attacksOnSameTarget = 0;
            }
        } else {
            this.attacksOnSameTarget = 0;
            this.lastTarget = null;
        }
        this.cooldown = this.dragon.getRandom().nextInt(61) + 60;
    }
}

