/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.allay.control;

import dev.xylonity.companions.common.entity.companion.GoldenAllayEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;

public class GoldenAllayMoveControl
extends MoveControl {
    private final GoldenAllayEntity allay;

    public GoldenAllayMoveControl(GoldenAllayEntity allay) {
        super((Mob)allay);
        this.allay = allay;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.WAIT) {
            this.allay.setDeltaMovement(Vec3.ZERO);
            return;
        }
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            Vec3 vv = new Vec3(this.wantedX - this.allay.getX(), this.wantedY - this.allay.getY(), this.wantedZ - this.allay.getZ());
            double length = vv.length();
            if (length < this.allay.getBoundingBox().getSize()) {
                this.operation = MoveControl.Operation.WAIT;
                this.allay.setDeltaMovement(this.allay.getDeltaMovement().scale(0.5));
            } else {
                this.allay.setDeltaMovement(this.allay.getDeltaMovement().add(vv.scale(this.speedModifier * 0.05 / length)));
                if (this.allay.getTarget() == null) {
                    Vec3 mov = this.allay.getDeltaMovement();
                    this.allay.setYRot(-((float)Mth.atan2((double)mov.x, (double)mov.z)) * 57.295776f);
                } else {
                    double x = this.allay.getTarget().getX() - this.allay.getX();
                    double z = this.allay.getTarget().getZ() - this.allay.getZ();
                    this.allay.setYRot(-((float)Mth.atan2((double)x, (double)z)) * 57.295776f);
                }
                this.allay.yBodyRot = this.allay.getYRot();
            }
        }
    }
}

