/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.goal;

import dev.xylonity.companions.common.entity.ai.mage.AbstractSoulMageAttackGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;

public class SoulMageHealRingGoal
extends AbstractSoulMageAttackGoal {
    public SoulMageHealRingGoal(SoulMageEntity soulMage, int minCd, int maxCd) {
        super(soulMage, minCd, maxCd, "HEAL_RING");
    }

    @Override
    public boolean canUse() {
        if (this.soulMage.isAttacking()) {
            return false;
        }
        if (this.soulMage.tickCount < this.nextUseTick) {
            return false;
        }
        if (!this.hasRequiredBook()) {
            return false;
        }
        if (this.soulMage.getOwner() == null) {
            return false;
        }
        return !((double)this.soulMage.getOwner().getHealth() >= (double)this.soulMage.getOwner().getMaxHealth() * 0.7);
    }

    @Override
    protected void performAttack(LivingEntity target) {
        Projectile ring;
        if (this.soulMage.getOwner() != null && (ring = (Projectile)CompanionsEntities.HEAL_RING_PROJECTILE.get().create(this.soulMage.level())) != null) {
            ring.moveTo(this.soulMage.getOwner().getX(), this.soulMage.getOwner().getY(), this.soulMage.getOwner().getZ());
            ring.setOwner((Entity)this.soulMage.getOwner());
            this.soulMage.level().addFreshEntity((Entity)ring);
        }
    }

    @Override
    protected boolean hasRequiredBook() {
        for (int i = 0; i < this.soulMage.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.soulMage.inventory.getItem(i);
            if (stack.getItem() != CompanionsItems.BOOK_HEAL_RING.get()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldPerformAttack(LivingEntity target) {
        return this.attackTicks == 6;
    }
}

