/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.goal;

import dev.xylonity.companions.common.entity.ai.mage.AbstractSoulMageAttackGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.TornadoProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class SoulMageTornadoGoal
extends AbstractSoulMageAttackGoal {
    public SoulMageTornadoGoal(SoulMageEntity soulMage, int minCd, int maxCd) {
        super(soulMage, minCd, maxCd, "TORNADO");
    }

    @Override
    protected void performAttack(LivingEntity target) {
        TornadoProjectile tornado = (TornadoProjectile)CompanionsEntities.TORNADO_PROJECTILE.get().create(this.soulMage.level());
        if (tornado != null && target != null) {
            Vec3 startPos = this.soulMage.getEyePosition(1.0f);
            Vec3 spawnPos = startPos.add(target.getEyePosition(1.0f).subtract(startPos).normalize());
            tornado.moveTo(spawnPos.x, spawnPos.y - 1.0, spawnPos.z);
            tornado.setOwner((Entity)this.soulMage);
            this.soulMage.level().addFreshEntity((Entity)tornado);
        }
    }

    @Override
    protected boolean hasRequiredBook() {
        for (int i = 0; i < this.soulMage.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.soulMage.inventory.getItem(i);
            if (stack.getItem() != CompanionsItems.BOOK_ICE_TORNADO.get()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldPerformAttack(LivingEntity target) {
        return this.attackTicks == 6;
    }
}

