/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mankh.goal;

import dev.xylonity.companions.common.entity.ai.mankh.AbstractMankhAttackGoal;
import dev.xylonity.companions.common.entity.companion.MankhEntity;
import dev.xylonity.companions.common.entity.projectile.trigger.LaserTriggerProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class MankhChestShotAttackGoal
extends AbstractMankhAttackGoal {
    public MankhChestShotAttackGoal(MankhEntity mankh, int minCd, int maxCd) {
        super(mankh, 80, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.mankh.setNoMovement(true);
        this.mankh.playSound(CompanionsSounds.MANKH_BEAM.get());
    }

    @Override
    public void stop() {
        super.stop();
        this.mankh.setNoMovement(false);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.mankh.getTarget() != null) {
            Vec3 dir = this.mankh.getTarget().getEyePosition().subtract(this.mankh.getEyePosition()).normalize();
            float yaw = (float)(Math.atan2(-dir.x, dir.z) * 180.0 / Math.PI);
            float pitch = (float)(Math.asin(-dir.y) * 180.0 / Math.PI);
            this.mankh.setYRot(yaw);
            this.mankh.setXRot(pitch);
            this.mankh.yRotO = yaw;
            this.mankh.xRotO = pitch;
        }
        if (this.mankh.getTarget() != null) {
            this.mankh.lookAt((Entity)this.mankh.getTarget(), 30.0f, 30.0f);
        }
    }

    @Override
    protected void performAttack(LivingEntity target) {
        Vec3 dir = target.getEyePosition().subtract(this.mankh.getEyePosition()).normalize();
        LaserTriggerProjectile laser = (LaserTriggerProjectile)CompanionsEntities.LASER_PROJECTILE.get().create(this.mankh.level());
        if (laser != null) {
            Vec3 spawn = this.mankh.position().add(0.0, (double)this.mankh.getBbHeight() * 0.5, 0.0).add(dir.scale(0.05));
            laser.setPos(spawn.x, spawn.y, spawn.z);
            laser.setOwner((Entity)this.mankh);
            laser.setTarget(target);
            this.mankh.level().addFreshEntity((Entity)laser);
        }
    }

    @Override
    protected int attackDelay() {
        return 14;
    }

    @Override
    protected int attackType() {
        return 1;
    }
}

