/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.minion.hostile;

import dev.xylonity.companions.common.entity.hostile.HostileImpEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AbstractHostileImpAttackGoal
extends Goal {
    protected final HostileImpEntity imp;
    protected final int attackDuration;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractHostileImpAttackGoal(HostileImpEntity imp, int attackDuration, int minCd, int maxCd) {
        this.imp = imp;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.imp.getAttackType() != 0) {
            return false;
        }
        if (this.imp.getTarget() == null) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.imp.tickCount + this.minCooldown + this.imp.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.imp.tickCount >= this.nextUseTick;
    }

    public boolean canContinueToUse() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void start() {
        this.attackTicks = 0;
        this.started = true;
        this.imp.setAttackType(this.attackType());
    }

    public void stop() {
        this.started = false;
        this.imp.setAttackType(0);
        int cd = this.minCooldown + this.imp.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.imp.tickCount + cd;
    }

    public void tick() {
        LivingEntity target = this.imp.getTarget();
        if (target != null) {
            this.imp.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            this.imp.lookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();

    protected abstract int attackType();
}

