/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.minion.tamable;

import dev.xylonity.companions.common.entity.companion.MinionEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class AbstractMinionAttackGoal
extends Goal {
    protected final MinionEntity minion;
    protected final int attackDuration;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractMinionAttackGoal(MinionEntity pontiff, int attackDuration, int minCd, int maxCd) {
        this.minion = pontiff;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.minion.getVariant().equals(this.variant())) {
            return false;
        }
        if (this.minion.getAttackType() != 0) {
            return false;
        }
        if (this.minion.getTarget() == null) {
            return false;
        }
        if (this.minion.getMainAction() != 1) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.minion.tickCount + this.minCooldown + this.minion.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.minion.tickCount >= this.nextUseTick;
    }

    public boolean canContinueToUse() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void start() {
        this.attackTicks = 0;
        this.started = true;
        this.minion.setAttackType(this.attackType());
    }

    public void stop() {
        this.started = false;
        this.minion.setAttackType(0);
        int cd = this.minCooldown + this.minion.getRandom().nextInt(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.minion.tickCount + cd;
    }

    public void tick() {
        LivingEntity target = this.minion.getTarget();
        if (target != null) {
            this.minion.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();

    protected abstract String variant();

    protected abstract int attackType();
}

