/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff.goal;

import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.entity.ai.pontiff.AbstractSacredPontiffAttackGoal;
import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PontiffDashAttackGoal
extends AbstractSacredPontiffAttackGoal {
    private Vec3 dashVelocity = Vec3.ZERO;
    private boolean isDashing = false;

    public PontiffDashAttackGoal(SacredPontiffEntity boss, int minCd, int maxCd) {
        super(boss, 50, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.pontiff.getNavigation().stop();
        this.isDashing = false;
        this.pontiff.playSound(CompanionsSounds.PONTIFF_AREA_ATTACK.get());
    }

    @Override
    public void stop() {
        super.stop();
        this.pontiff.setDeltaMovement(Vec3.ZERO);
        this.pontiff.hasImpulse = true;
        this.pontiff.setNoGravity(false);
        this.isDashing = false;
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.pontiff.getTarget() != null && this.pontiff.distanceTo((Entity)this.pontiff.getTarget()) < 10.0f && this.pontiff.hasLineOfSight((Entity)this.pontiff.getTarget());
    }

    @Override
    protected int getAttackType() {
        return 4;
    }

    @Override
    public void tick() {
        LivingEntity tgt;
        super.tick();
        if (this.attackTicks == 20 && !this.isDashing && (tgt = this.pontiff.getTarget()) != null) {
            Vec3 dashTargetPos = tgt.position();
            Vec3 dir = dashTargetPos.subtract(this.pontiff.position());
            dir = new Vec3(dir.x, 0.0, dir.z);
            this.dashVelocity = dir.normalize().scale(0.26666666666666666);
            this.isDashing = true;
            this.pontiff.setNoGravity(true);
        }
        if (this.isDashing && this.attackTicks >= 20 && this.attackTicks <= 50) {
            double groundY = this.pontiff.getY();
            BlockPos base = new BlockPos((int)this.pontiff.getX(), (int)(this.pontiff.getY() - 0.05), (int)this.pontiff.getZ());
            for (int i = 0; i < 3; ++i) {
                BlockPos check = base.below(i);
                if (this.pontiff.level().getBlockState(check).getCollisionShape((BlockGetter)this.pontiff.level(), check).isEmpty()) continue;
                groundY = (double)check.getY() + 1.0;
                break;
            }
            this.pontiff.setPos(this.pontiff.getX(), groundY, this.pontiff.getZ());
            this.pontiff.setDeltaMovement(this.dashVelocity.x, 0.0, this.dashVelocity.z);
            this.pontiff.hasImpulse = true;
            float yaw = (float)(Math.toDegrees(Math.atan2(this.dashVelocity.z, this.dashVelocity.x)) - 90.0);
            this.pontiff.setYRot(yaw);
            this.pontiff.yBodyRot = yaw;
            this.pontiff.yHeadRot = yaw;
        }
        if (this.isDashing && this.attackTicks > 50) {
            this.pontiff.setNoGravity(false);
            this.isDashing = false;
        }
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (Entity e2 : this.pontiff.level().getEntitiesOfClass(Entity.class, new AABB(new BlockPos((int)this.pontiff.getX(), (int)this.pontiff.getY(), (int)this.pontiff.getZ())).inflate(5.0), e -> !(e instanceof HostileEntity))) {
            LivingEntity livingEntity;
            if (!(e2 instanceof LivingEntity) || !this.pontiff.hasLineOfSight((Entity)(livingEntity = (LivingEntity)e2)) || !PontiffDashAttackGoal.isEntityInFront((LivingEntity)this.pontiff, (Entity)livingEntity, 220.0)) continue;
            this.pontiff.doHurtTarget((Entity)livingEntity);
            livingEntity.knockback(0.75, this.pontiff.getX() - livingEntity.getX(), this.pontiff.getZ() - livingEntity.getZ());
        }
    }

    @Override
    protected int attackDelay() {
        return 32;
    }

    @Override
    protected int attackState() {
        return 2;
    }
}

