/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.shade.sword.goal;

import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.ai.shade.AbstractShadeAttackGoal;
import dev.xylonity.companions.common.entity.companion.ShadeSwordEntity;
import dev.xylonity.companions.common.entity.projectile.ShadeSwordImpactProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class ShadeSwordGroundAttackGoal
extends AbstractShadeAttackGoal {
    public ShadeSwordGroundAttackGoal(ShadeEntity boss, int minCd, int maxCd) {
        super(boss, 42, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.shade.setNoMovement(true);
        this.shade.playSound(CompanionsSounds.SHADE_SWORD_SLASH.get());
    }

    @Override
    public void stop() {
        super.stop();
        this.shade.setNoMovement(false);
        this.shade.setDeltaMovement(Vec3.ZERO);
        this.shade.setShouldLookAtTarget(true);
    }

    @Override
    public boolean canUse() {
        if (!super.canUse()) {
            return false;
        }
        if (this.shade.getTarget() == null || (double)this.shade.distanceTo((Entity)this.shade.getTarget()) >= 8.0) {
            return false;
        }
        int groundY = this.shade.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.shade.blockPosition()).getY();
        return this.shade.getY() - (double)groundY <= 1.5;
    }

    @Override
    protected int getAttackType() {
        return 3;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            ShadeSwordImpactProjectile impact = (ShadeSwordImpactProjectile)CompanionsEntities.SHADE_SWORD_IMPACT_PROJECTILE.get().create(this.shade.level());
            if (impact == null) continue;
            BlockPos base = this.shade.blockPosition().relative(dir);
            impact.setOwner((Entity)this.shade);
            impact.moveTo((double)base.getX() + 0.5, Math.min(this.shade.getY(), (double)this.shade.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, base).getY() + 0.1), (double)base.getZ() + 0.5, dir.toYRot(), 0.0f);
            impact.setDirection(dir);
            impact.setDeltaMovement(new Vec3((double)dir.getStepX(), 0.0, (double)dir.getStepZ()).scale(0.375));
            this.shade.level().addFreshEntity((Entity)impact);
        }
    }

    @Override
    protected int attackDelay() {
        return 14;
    }

    @Override
    protected Class<? extends ShadeEntity> shadeType() {
        return ShadeSwordEntity.class;
    }
}

