/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.shade.sword.goal;

import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.entity.ai.shade.AbstractShadeAttackGoal;
import dev.xylonity.companions.common.entity.companion.ShadeSwordEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ShadeSwordSpinAttackGoal
extends AbstractShadeAttackGoal {
    private double anchorY;

    public ShadeSwordSpinAttackGoal(ShadeEntity boss, int minCd, int maxCd) {
        super(boss, 30, minCd, maxCd);
    }

    @Override
    public void start() {
        super.start();
        this.shade.setNoMovement(true);
        this.anchorY = this.shade.getY();
        this.shade.playSound(CompanionsSounds.SHADE_SWORD_SPIN_SLASH.get());
    }

    @Override
    public void stop() {
        super.stop();
        this.shade.setNoMovement(false);
        this.shade.setDeltaMovement(Vec3.ZERO);
        this.shade.setShouldLookAtTarget(true);
    }

    @Override
    public void tick() {
        LivingEntity target;
        if (this.attackTicks < 4) {
            this.shade.setShouldLookAtTarget(false);
        }
        if ((target = this.shade.getTarget()) != null) {
            this.shade.setPos(this.shade.getX(), this.anchorY, this.shade.getZ());
            this.shade.setDeltaMovement(Vec3.ZERO);
            float yaw = (float)(180.0 + Math.toDegrees(Math.atan2(target.getX() - this.shade.getX(), target.getZ() - this.shade.getZ())));
            this.shade.setYRot(yaw);
            this.shade.setYBodyRot(yaw);
        }
        if (target != null) {
            this.shade.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks >= 5 && this.attackTicks <= 26 && this.attackTicks % 5 == 0 && target != null && target.isAlive()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    @Override
    public boolean canUse() {
        return super.canUse() && this.shade.getTarget() != null && this.shade.distanceTo((Entity)this.shade.getTarget()) < 3.0f;
    }

    @Override
    protected int getAttackType() {
        return 4;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (Entity e : this.shade.level().getEntitiesOfClass(Entity.class, this.shade.getBoundingBox().inflate(3.25))) {
            LivingEntity livingEntity;
            if (!(e instanceof LivingEntity) || !this.shade.hasLineOfSight((Entity)(livingEntity = (LivingEntity)e)) || Util.areEntitiesLinked(e, (Entity)this.shade)) continue;
            this.shade.doHurtTarget((Entity)livingEntity);
            livingEntity.knockback(0.5, this.shade.getX() - target.getX(), this.shade.getZ() - target.getZ());
        }
    }

    @Override
    protected int attackDelay() {
        return 0;
    }

    @Override
    protected Class<? extends ShadeEntity> shadeType() {
        return ShadeSwordEntity.class;
    }
}

