/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.teddy.goal;

import dev.xylonity.companions.common.entity.companion.TeddyEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;

public class TeddyApproachTargetGoal
extends Goal {
    private final TeddyEntity teddy;
    private LivingEntity target;
    private final PathNavigation navigation;
    private final double speedModifier;
    private final float startDistance;
    private final float stopDistance;
    private int timeToRecalcPath;

    public TeddyApproachTargetGoal(TeddyEntity teddy, double speedModifier, float startDistance, float stopDistance) {
        this.teddy = teddy;
        this.speedModifier = speedModifier;
        this.startDistance = startDistance;
        this.stopDistance = stopDistance;
        this.navigation = teddy.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity t = this.teddy.getTarget();
        if (this.teddy.getPhase() == 2) {
            return false;
        }
        if (t == null || !t.isAlive()) {
            return false;
        }
        this.target = t;
        return this.teddy.distanceToSqr((Entity)this.target) > (double)(this.startDistance * this.startDistance);
    }

    public boolean canContinueToUse() {
        return this.target != null && this.target.isAlive() && !this.navigation.isDone();
    }

    public void start() {
        this.timeToRecalcPath = 0;
    }

    public void stop() {
        this.target = null;
        this.navigation.stop();
    }

    public void tick() {
        if (this.target == null) {
            return;
        }
        this.teddy.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            double distanceToTargetSq = this.teddy.distanceToSqr((Entity)this.target);
            if (distanceToTargetSq > (double)(this.startDistance * this.startDistance)) {
                this.navigation.moveTo((Entity)this.target, this.speedModifier);
            } else if (distanceToTargetSq < (double)(this.stopDistance * this.stopDistance)) {
                this.navigation.stop();
            }
        }
    }
}

