/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionAdultAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionAdultFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionBaseAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionBaseLongAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionPupaApproachTargetGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionPupaAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionSoldierAttackGoal;
import dev.xylonity.companions.common.entity.ai.antlion.tamable.goal.AntlionSoldierLongAttackGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import dev.xylonity.knightlib.api.TickScheduler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class AntlionEntity
extends CompanionEntity
implements PlayerRideable {
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation SIT2 = RawAnimation.begin().thenPlay("sit2");
    private final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
    private final RawAnimation DIG_IN = RawAnimation.begin().thenPlay("dig");
    private final RawAnimation DIG_OUT = RawAnimation.begin().thenPlay("dig_out");
    private final RawAnimation DIG_IDLE = RawAnimation.begin().thenPlay("dig_idle");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private final RawAnimation TURN = RawAnimation.begin().thenPlay("turn");
    private final RawAnimation UNSTUCK = RawAnimation.begin().thenPlay("unstuck");
    private final RawAnimation FALL_IDLE = RawAnimation.begin().thenPlay("fall_idle");
    private final RawAnimation HIT_GROUND = RawAnimation.begin().thenPlay("hit_ground");
    private final RawAnimation DIG_ATTACK = RawAnimation.begin().thenPlay("dig_attack");
    private final RawAnimation DIG_SHOOT = RawAnimation.begin().thenPlay("dig_attack2");
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.defineId(AntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(AntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(AntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> HAS_FUR = SynchedEntityData.defineId(AntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_LOCKED = SynchedEntityData.defineId(AntlionEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final int ANIMATION_BASE_DIG_IN_TICKS = 55;
    private static final int ANIMATION_BASE_DIG_OUT_TICKS = 15;
    private static final int ANIMATION_ADULT_HIT_GROUND_TICKS = 7;
    private static final int ANIMATION_ADULT_UNSTUCK_TICKS = 35;
    private static final int ANIMATION_ADULT_TURN_TICKS = 10;
    private static final int MAX_FALL_TICKS = 8;
    private static final int NO_TARGET_MAX_TICKS = 20;
    private static final float MIN_SPEED_FOR_DESCENT = 0.3f;
    private static final float MAX_SPEED_FOR_DESCENT = 1.01f;
    private Vec3 vel = Vec3.ZERO;
    private int diginCounter = -1;
    private int digoutCounter = -1;
    private int noTargetCounter = -1;
    private int hitGroundCounter = -1;
    private int unstuckCounter = -1;
    private int turnCounter = -1;
    private int fallCounter = -1;
    private float throttle = 0.0f;
    private boolean wasNight = this.level().isNight();

    public AntlionEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void tick() {
        super.tick();
        this.setNoGravity(this.getVariant() == 2);
        if (!this.level().isClientSide) {
            if (this.getVariant() == 0) {
                this.setNoMovement(this.isUnderground() || this.getState() == 1);
                if (this.getState() == 1 && this.diginCounter == -1) {
                    ++this.diginCounter;
                }
                if (this.getState() == 2 && this.noTargetCounter == -1 && this.getTarget() == null) {
                    ++this.noTargetCounter;
                } else if (this.getState() == 2 && this.noTargetCounter == -1 && this.getTarget() == null) {
                    this.noTargetCounter = -1;
                }
                if (this.diginCounter != -1) {
                    ++this.diginCounter;
                }
                if (this.digoutCounter != -1) {
                    ++this.digoutCounter;
                }
                if (this.noTargetCounter != -1) {
                    ++this.noTargetCounter;
                }
                if (this.diginCounter == 55) {
                    this.cycleState();
                    this.diginCounter = -1;
                }
                if (this.noTargetCounter == 20) {
                    this.cycleState();
                    this.noTargetCounter = -1;
                    ++this.digoutCounter;
                }
                if (this.digoutCounter == 15) {
                    this.cycleState();
                    this.digoutCounter = -1;
                }
                if (this.diginCounter == 20 || this.diginCounter == 35 || this.digoutCounter == 5) {
                    this.earthquake();
                }
            } else if (this.getVariant() == 2) {
                if (this.tickCount % 30 == 0 && this.getMainAction() != 0) {
                    this.playSound(CompanionsSounds.ADULT_ANTLION_FLY.get());
                }
                this.setNoMovement(this.getState() != 0);
                if (this.getState() == 1 && this.turnCounter == -1) {
                    this.turnCounter = 0;
                }
                if (this.getState() == 2 && this.fallCounter == -1) {
                    this.fallCounter = 0;
                }
                if (this.getState() == 3 && this.hitGroundCounter == -1) {
                    this.hitGroundCounter = 0;
                }
                if (this.getState() == 4 && this.unstuckCounter == -1) {
                    this.unstuckCounter = 0;
                }
                if (this.hitGroundCounter != -1) {
                    ++this.hitGroundCounter;
                }
                if (this.fallCounter != -1) {
                    ++this.fallCounter;
                }
                if (this.unstuckCounter != -1) {
                    ++this.unstuckCounter;
                }
                if (this.turnCounter != -1) {
                    ++this.turnCounter;
                }
                if (this.fallCounter >= 8) {
                    this.cycleState();
                    this.fallCounter = -1;
                }
                if (this.hitGroundCounter >= 7) {
                    this.cycleState();
                    this.hitGroundCounter = -1;
                }
                if (this.unstuckCounter >= 35) {
                    this.cycleState();
                    this.unstuckCounter = -1;
                }
                if (this.turnCounter >= 10) {
                    this.cycleState();
                    this.turnCounter = -1;
                }
            }
            boolean nowNight = this.level().isNight();
            if (this.wasNight && !nowNight) {
                if (!this.isPhaseLocked()) {
                    this.cycleVariant();
                }
                this.setHasFur(true);
                this.setState(0);
            }
            this.wasNight = nowNight;
        }
    }

    public void setOrderedToSit(boolean pOrderedToSit) {
        BlockPos groundPos;
        super.setOrderedToSit(pOrderedToSit);
        if (!this.level().isClientSide && pOrderedToSit && this.getVariant() == 2 && (groundPos = Util.findClosestGroundBelow(this, 7.0f)) != null) {
            double y = (double)groundPos.getY() + 1.0;
            this.teleportTo(this.getX(), y, this.getZ());
        }
    }

    private void earthquake() {
        int radius = 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int dist = Math.abs(x) + Math.abs(z);
                if (dist < 1 || dist > radius) continue;
                BlockPos blockPos = this.blockPosition().offset(x, -1, z);
                BlockState state = this.level().getBlockState(blockPos);
                if (state.isAir() || state.getBlock() == Blocks.BEDROCK) continue;
                if (dist == 1) {
                    this.spawnFallingBlock(blockPos, state, 0.18);
                    continue;
                }
                TickScheduler.scheduleServer((Level)this.level(), () -> this.spawnFallingBlock(blockPos, state, 0.2), (int)5);
            }
        }
    }

    private void spawnFallingBlock(BlockPos pos, BlockState state, double yDelay) {
        FallingBlockEntity block = new FallingBlockEntity(this.level(), (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, state);
        block.setDeltaMovement(0.0, yDelay, 0.0);
        this.level().addFreshEntity((Entity)block);
        this.level().removeBlock(pos, false);
    }

    public void cycleState() {
        if (this.getVariant() == 0) {
            switch (this.getState()) {
                case 0: {
                    this.setState(1);
                    break;
                }
                case 1: {
                    this.setState(2);
                    break;
                }
                case 2: {
                    this.setState(3);
                    break;
                }
                case 3: {
                    this.setState(0);
                }
            }
        } else if (this.getVariant() == 2) {
            switch (this.getState()) {
                case 0: {
                    this.setState(1);
                    break;
                }
                case 1: {
                    this.setState(2);
                    break;
                }
                case 2: {
                    this.setState(3);
                    break;
                }
                case 3: {
                    this.setState(4);
                    break;
                }
                case 4: {
                    this.setState(0);
                }
            }
        }
    }

    public void cycleVariant() {
        switch (this.getVariant()) {
            case 0: {
                this.setVariant(1);
                break;
            }
            case 1: {
                this.setVariant(2);
                break;
            }
            case 2: {
                this.setVariant(3);
                break;
            }
            case 3: {
                this.setVariant(0);
            }
        }
        this.spawnVariantParticles();
        this.updateStats();
        this.playSound(CompanionsSounds.SPELL_RELEASE_SPEARS.get());
        if (this.getVariant() == 2) {
            this.playSound(CompanionsSounds.ADULT_ANTLION_FLY.get());
        }
    }

    private void updateStats() {
        AttributeInstance damage;
        AttributeInstance maxHealth = this.getAttribute(Attributes.MAX_HEALTH);
        if (maxHealth != null) {
            double prevHealth = (double)this.getMaxHealth() * 0.95;
            switch (this.getVariant()) {
                case 0: {
                    maxHealth.setBaseValue(CompanionsConfig.ANTLION_NORMAL_MAX_LIFE);
                    if (!((double)this.getHealth() >= prevHealth)) break;
                    this.setHealth((float)CompanionsConfig.ANTLION_NORMAL_MAX_LIFE);
                    break;
                }
                case 1: {
                    maxHealth.setBaseValue(CompanionsConfig.ANTLION_TANK_MAX_LIFE);
                    if (!((double)this.getHealth() >= prevHealth)) break;
                    this.setHealth((float)CompanionsConfig.ANTLION_TANK_MAX_LIFE);
                    break;
                }
                case 2: {
                    maxHealth.setBaseValue(CompanionsConfig.ANTLION_FLYER_MAX_LIFE);
                    if (!((double)this.getHealth() >= prevHealth)) break;
                    this.setHealth((float)CompanionsConfig.ANTLION_FLYER_MAX_LIFE);
                    break;
                }
                default: {
                    maxHealth.setBaseValue(CompanionsConfig.ANTLION_SOLDIER_MAX_LIFE);
                    if (!((double)this.getHealth() >= prevHealth)) break;
                    this.setHealth((float)CompanionsConfig.ANTLION_SOLDIER_MAX_LIFE);
                }
            }
        }
        if ((damage = this.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
            switch (this.getVariant()) {
                case 0: {
                    damage.setBaseValue(CompanionsConfig.ANTLION_NORMAL_DAMAGE);
                    break;
                }
                case 1: {
                    damage.setBaseValue(CompanionsConfig.ANTLION_TANK_DAMAGE);
                    break;
                }
                case 2: {
                    damage.setBaseValue(CompanionsConfig.ANTLION_FLYER_DAMAGE);
                    break;
                }
                default: {
                    damage.setBaseValue(CompanionsConfig.ANTLION_SOLDIER_DAMAGE);
                }
            }
        }
    }

    private void spawnVariantParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.level().random.nextDouble() - 0.5) * 0.75;
            double dy = (this.level().random.nextDouble() - 0.5) * 0.75;
            double dz = (this.level().random.nextDouble() - 0.5) * 0.75;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.position().x, this.position().y + (double)(this.getBbHeight() * 0.5f), this.position().z, 1, dx, dy, dz, 0.1);
        }
    }

    public void setState(int state) {
        this.entityData.set(STATE, (Object)state);
    }

    public int getState() {
        return (Integer)this.entityData.get(STATE);
    }

    public boolean isUnderground() {
        return this.getVariant() == 0 && this.getState() == 2;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new AntlionBaseAttackGoal(this, 20, 60));
        this.goalSelector.addGoal(2, (Goal)new AntlionBaseLongAttackGoal(this, 20, 60));
        this.goalSelector.addGoal(2, (Goal)new AntlionPupaAttackGoal(this, 20, 60));
        this.goalSelector.addGoal(3, (Goal)new AntlionPupaApproachTargetGoal(this, 0.475, 0.4f, 1.25f));
        this.goalSelector.addGoal(2, (Goal)new AntlionAdultAttackGoal(this, 20, 60));
        this.goalSelector.addGoal(2, (Goal)new AntlionSoldierAttackGoal(this, 20, 60));
        this.goalSelector.addGoal(2, (Goal)new AntlionSoldierLongAttackGoal(this, 20, 60));
        this.goalSelector.addGoal(4, (Goal)new AntlionAdultFollowOwnerGoal(this, 0.6, 3.0, 7.0, 0.18f));
        this.goalSelector.addGoal(4, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false){

            @Override
            public boolean canUse() {
                return super.canUse() && AntlionEntity.this.getVariant() != 2;
            }
        });
        this.goalSelector.addGoal(4, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.goalSelector.addGoal(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    public static AttributeSupplier setAttributes() {
        return CompanionEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    public boolean isPhaseLocked() {
        return (Boolean)this.entityData.get(IS_LOCKED);
    }

    public void setIsPhaseLocked(boolean phase) {
        this.entityData.set(IS_LOCKED, (Object)phase);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public boolean hasFur() {
        return (Boolean)this.entityData.get(HAS_FUR);
    }

    public void setHasFur(boolean hasFur) {
        this.entityData.set(HAS_FUR, (Object)hasFur);
    }

    public int getAttackType() {
        return (Integer)this.entityData.get(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.entityData.set(ATTACK_TYPE, (Object)type);
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return this.getVariant() != 2 && super.causeFallDamage(pFallDistance, pMultiplier, pSource);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(ATTACK_TYPE, (Object)0);
        builder.define(STATE, (Object)0);
        builder.define(IS_LOCKED, (Object)false);
        builder.define(HAS_FUR, (Object)true);
    }

    public void move(@NotNull MoverType pType, @NotNull Vec3 pPos) {
        super.move(pType, pPos);
        this.checkInsideBlocks();
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (this.isTame() && player == this.getOwner() && item == CompanionsItems.NETHERITE_CHAINS.get() && !this.isPhaseLocked()) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!player.getAbilities().instabuild) {
                player.getItemInHand(hand).shrink(1);
            }
            for (int i = 0; i < 20; ++i) {
                double dx = (this.random.nextDouble() - 0.5) * 2.0;
                double dy = (this.random.nextDouble() - 0.5) * 2.0;
                double dz = (this.random.nextDouble() - 0.5) * 2.0;
                Level level = this.level();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel level2 = (ServerLevel)level;
                if (level2.random.nextFloat() < 0.65f) {
                    level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1);
                }
                if (!(level2.random.nextFloat() < 0.25f)) continue;
                level2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.2);
            }
            this.playSound(CompanionsSounds.SPELL_RELEASE_MARK.get());
            this.setIsPhaseLocked(true);
            return InteractionResult.SUCCESS;
        }
        if (item == Items.SHEARS && this.isTame() && this.getOwner() != null && this.getOwner() == player && this.getVariant() == 0 && this.hasFur()) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            this.setHasFur(false);
            AntlionEntity.popResource(this.level(), this.blockPosition(), new ItemStack((ItemLike)CompanionsItems.ANTLION_FUR.get(), this.level().random.nextInt(1, 4)));
            itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, this.getSoundSource(), 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (item == CompanionsItems.HOURGLASS.get() && this.isTame() && this.getOwner() != null && this.getOwner() == player && !this.isPhaseLocked()) {
            if (this.level().isClientSide) {
                return InteractionResult.SUCCESS;
            }
            itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            this.cycleVariant();
            return InteractionResult.SUCCESS;
        }
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && player == this.getOwner() && this.getVariant() == 2) {
            if (player.isShiftKeyDown()) {
                if (this.handleDefaultMainActionAndHeal(player, hand)) {
                    return InteractionResult.SUCCESS;
                }
            } else if (this.getMainAction() != 0) {
                player.startRiding((Entity)this, true);
                return InteractionResult.SUCCESS;
            }
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setIsPhaseLocked(pCompound.getBoolean("IsVariantLocked"));
        if (pCompound.contains("Variant")) {
            this.setVariant(pCompound.getInt("Variant"));
        }
        if (pCompound.contains("HasFur")) {
            this.setHasFur(pCompound.getBoolean("HasFur"));
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Variant", this.getVariant());
        pCompound.putBoolean("HasFur", this.hasFur());
        pCompound.putBoolean("IsVariantLocked", this.isPhaseLocked());
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.ANTLION_KEEP_CHUNK_LOADED;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity;
        if (!this.isNoAi() && (entity = this.getFirstPassenger()) instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            return e;
        }
        return null;
    }

    public void travel(@NotNull Vec3 travelVec) {
        LivingEntity rider = this.getControllingPassenger();
        if (rider == null || !this.isVehicle()) {
            super.travel(travelVec);
            return;
        }
        this.setYRot(rider.getYRot());
        this.yBodyRot = this.yRotO = this.getYRot();
        this.setXRot(rider.getXRot() * 0.5f);
        this.throttle = rider.zza > 0.05f ? Mth.clamp((float)(this.throttle + 0.06f), (float)-1.0f, (float)1.0f) : (rider.zza < -0.05f ? Mth.clamp((float)(this.throttle - 0.06f), (float)-1.0f, (float)1.0f) : Mth.lerp((float)0.2f, (float)this.throttle, (float)0.0f));
        float speed = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 1.1f * this.throttle;
        if (this.onGround()) {
            speed *= 0.05f;
        }
        float speedMag = Math.abs(speed);
        Vec3 aim = rider.getLookAngle().normalize();
        Vec3 desired = new Vec3(aim.x * (double)speed, 0.0, aim.z * (double)speed);
        double newY = speedMag > 0.3f ? -(0.3225 * Mth.clamp((double)((speedMag - 0.3f) / 0.71f), (double)0.0, (double)1.0)) : aim.y * (double)speed;
        desired = desired.with(Direction.Axis.Y, newY);
        this.vel = this.vel.lerp(desired, (double)0.2825f);
        if (this.horizontalCollision) {
            this.vel = new Vec3(0.0, this.vel.y, 0.0);
            this.throttle = 0.0f;
        }
        this.move(MoverType.SELF, this.vel);
        this.setDeltaMovement(this.vel);
    }

    private static void popResource(Level pLevel, BlockPos pPos, ItemStack pStack) {
        double d0 = EntityType.ITEM.getHeight() / 2.0f;
        double d1 = (double)pPos.getX() + 0.5;
        double d2 = (double)pPos.getY() + 1.5 + Mth.nextDouble((RandomSource)pLevel.random, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.getZ() + 0.5;
        AntlionEntity.popResource(pLevel, () -> new ItemEntity(pLevel, d1, d2, d3, pStack, -0.25 + Math.random() * 0.25, -0.35 + Math.random() * (double)0.35f, -0.25 + Math.random() * 0.25), pStack);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier, ItemStack pStack) {
        if (!pLevel.isClientSide && !pStack.isEmpty()) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.setDefaultPickUpDelay();
            pLevel.addFreshEntity((Entity)itementity);
        }
    }

    protected void positionRider(@NotNull Entity pPassenger, @NotNull Entity.MoveFunction pCallback) {
        if (this.hasPassenger(pPassenger)) {
            double baseY = this.getY();
            pCallback.accept(pPassenger, this.getX(), baseY, this.getZ());
        }
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return switch (this.getVariant()) {
            case 0, 1 -> CompanionsSounds.ANTLION_DEATH.get();
            case 2 -> CompanionsSounds.ADULT_ANTLION_DEATH.get();
            default -> CompanionsSounds.SOLDIER_ANTLION_DEATH.get();
        };
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return switch (this.getVariant()) {
            case 0, 1 -> CompanionsSounds.ANTLION_HURT.get();
            case 2 -> CompanionsSounds.ADULT_ANTLION_HURT.get();
            default -> CompanionsSounds.SOLDIER_ANTLION_HURT.get();
        };
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return switch (this.getVariant()) {
            case 0, 1, 2 -> CompanionsSounds.ANTLION_IDLE.get();
            default -> CompanionsSounds.SOLDIER_ANTLION_IDLE.get();
        };
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        switch (this.getVariant()) {
            case 0: {
                this.playSound(CompanionsSounds.ANTLION_STEPS.get());
                break;
            }
            case 1: {
                this.playSound(CompanionsSounds.PUPA_ANTLION_STEP.get());
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.playSound(CompanionsSounds.SOLDIER_ANTLION_STEP.get());
            }
        }
    }

    protected void tickRidden(@NotNull Player rider, @NotNull Vec3 travelVector) {
        super.tickRidden(rider, travelVector);
        if (this.getVariant() != 2) {
            rider.stopRiding();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "pupaController", 0, this::pupaPredicate));
    }

    private <T extends GeoAnimatable> PlayState pupaPredicate(AnimationState<T> event) {
        if (this.getVariant() == 1) {
            if (this.getAttackType() == 1) {
                event.getController().setAnimation(this.ATTACK);
            } else if (event.isMoving()) {
                event.getController().setAnimation(this.WALK);
            } else {
                event.getController().setAnimation(this.IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        switch (this.getVariant()) {
            case 0: {
                if (this.getMainAction() == 0) {
                    event.getController().setAnimation(this.SIT);
                    break;
                }
                if (this.getAttackType() == 1) {
                    event.getController().setAnimation(this.DIG_ATTACK);
                    break;
                }
                if (this.getAttackType() == 2) {
                    event.getController().setAnimation(this.DIG_SHOOT);
                    break;
                }
                if (this.getState() == 1) {
                    event.getController().setAnimation(this.DIG_IN);
                    break;
                }
                if (this.getState() == 2) {
                    event.getController().setAnimation(this.DIG_IDLE);
                    break;
                }
                if (this.getState() == 3) {
                    event.getController().setAnimation(this.DIG_OUT);
                    break;
                }
                if (event.isMoving()) {
                    event.getController().setAnimation(this.WALK);
                    break;
                }
                event.getController().setAnimation(this.IDLE);
                break;
            }
            case 2: {
                if (this.getMainAction() == 0) {
                    event.getController().setAnimation(this.SIT);
                    break;
                }
                if (this.getState() == 1) {
                    event.getController().setAnimation(this.TURN);
                    break;
                }
                if (this.getState() == 2) {
                    event.getController().setAnimation(this.FALL_IDLE);
                    break;
                }
                if (this.getState() == 3) {
                    event.getController().setAnimation(this.HIT_GROUND);
                    break;
                }
                if (this.getState() == 4) {
                    event.getController().setAnimation(this.UNSTUCK);
                    break;
                }
                event.getController().setAnimation(this.FLY);
                break;
            }
            case 3: {
                if (this.getMainAction() == 0) {
                    event.getController().setAnimation(this.getSitVariation() == 0 ? this.SIT : this.SIT2);
                    break;
                }
                if (this.getAttackType() == 1) {
                    event.getController().setAnimation(this.ATTACK);
                    break;
                }
                if (this.getAttackType() == 2) {
                    event.getController().setAnimation(this.SHOOT);
                    break;
                }
                if (event.isMoving()) {
                    event.getController().setAnimation(this.WALK);
                    break;
                }
                event.getController().setAnimation(this.IDLE);
            }
        }
        return PlayState.CONTINUE;
    }
}

