/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.container.CorneliusContainerMenu;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusAttackBeeGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusBubbleFrogGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusEmberPoleGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusEnderFrogGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusFireworkToadGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusMoveToBeeGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.CorneliusNetherBullfrogGoal;
import dev.xylonity.companions.common.entity.ai.cornelius.goal.HopToOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomHopStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.util.interfaces.IFrogJumpUtil;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class CorneliusEntity
extends CompanionEntity
implements ContainerListener,
IFrogJumpUtil {
    public SimpleContainer inventory;
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation SIT2 = RawAnimation.begin().thenPlay("sit2");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation SUMMON = RawAnimation.begin().thenPlay("summon");
    private final RawAnimation SUMMON2 = RawAnimation.begin().thenPlay("summon2");
    private final RawAnimation SUMMON3 = RawAnimation.begin().thenPlay("summon3");
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.defineId(CorneliusEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.defineId(CorneliusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> CAN_ATTACK = SynchedEntityData.defineId(CorneliusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> SUMMONED_COUNT = SynchedEntityData.defineId(CorneliusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CYCLE_COUNTER = SynchedEntityData.defineId(CorneliusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int MAX_CYCLE_TICKS = 20;

    public CorneliusEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.createInventory();
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void createInventory() {
        SimpleContainer oldInv = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (oldInv != null) {
            int min = Math.min(oldInv.getContainerSize(), this.inventory.getContainerSize());
            for (int i = 0; i < min; ++i) {
                ItemStack stack = oldInv.getItem(i);
                this.inventory.setItem(i, stack.copy());
            }
        }
        this.inventory.addListener((ContainerListener)this);
    }

    public int getCycleCount() {
        return (Integer)this.entityData.get(CYCLE_COUNTER);
    }

    public void setCycleCount(int count) {
        this.entityData.set(CYCLE_COUNTER, (Object)count);
    }

    @Override
    public boolean isPersistenceRequired() {
        return true;
    }

    protected int getInventorySize() {
        return 6;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new CorneliusFireworkToadGoal(this, 60, 260));
        this.goalSelector.addGoal(2, (Goal)new CorneliusNetherBullfrogGoal(this, 60, 260));
        this.goalSelector.addGoal(2, (Goal)new CorneliusBubbleFrogGoal(this, 60, 260));
        this.goalSelector.addGoal(2, (Goal)new CorneliusEnderFrogGoal(this, 60, 260));
        this.goalSelector.addGoal(2, (Goal)new CorneliusEmberPoleGoal(this, 60, 260));
        this.goalSelector.addGoal(3, (Goal)new CorneliusMoveToBeeGoal(this, 0.725));
        this.goalSelector.addGoal(3, (Goal)new CorneliusAttackBeeGoal(this, 10, 30));
        this.goalSelector.addGoal(4, new HopToOwnerGoal<CorneliusEntity>(this, 0.725, 6.0f, 2.0f, false));
        this.goalSelector.addGoal(4, (Goal)new CompanionRandomHopStrollGoal(this, 0.725));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    public boolean canAttack() {
        return (Boolean)this.entityData.get(CAN_ATTACK);
    }

    @Override
    public void setCanAttack(boolean canAttack) {
        this.entityData.set(CAN_ATTACK, (Object)canAttack);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getCycleCount() == 0) {
                this.playSound(CompanionsSounds.FROGGY_JUMP.get(), 0.5f, 1.0f);
            }
            if (this.getCycleCount() >= 12) {
                this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
            }
            if (this.getCycleCount() >= 0) {
                this.setCycleCount(this.getCycleCount() + 1);
            }
            if (this.getCycleCount() >= 20) {
                this.setCycleCount(-1);
            }
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.FROGGY_IDLE.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.FROGGY_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return CompanionsSounds.FROGGY_DEATH.get();
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.CORNELIUS_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_FLAGS, (Object)0);
        builder.define(CAN_ATTACK, (Object)true);
        builder.define(ATTACK_TYPE, (Object)0);
        builder.define(SUMMONED_COUNT, (Object)0);
        builder.define(CYCLE_COUNTER, (Object)-1);
    }

    @Override
    public int getAttackType() {
        return (Integer)this.entityData.get(ATTACK_TYPE);
    }

    public void setAttackType(int type) {
        this.entityData.set(ATTACK_TYPE, (Object)type);
    }

    public int getSummonedCount() {
        return (Integer)this.entityData.get(SUMMONED_COUNT);
    }

    public void setSummonedCount(int c) {
        this.entityData.set(SUMMONED_COUNT, (Object)c);
    }

    @Nullable
    public LivingEntity getOwner() {
        return super.getOwner();
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isTame() && this.getOwner() == player && player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            if (!this.level().isClientSide && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return CorneliusEntity.this.getName();
                    }

                    @Nullable
                    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                        return new CorneliusContainerMenu(i, inventory, CorneliusEntity.this);
                    }
                }, buf -> buf.writeInt(this.getId()));
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.inventory.fromTag(pCompound.getList("Inventory", 10), (HolderLookup.Provider)this.level().registryAccess());
        if (pCompound.contains("SummonedCount")) {
            this.setSummonedCount(pCompound.getInt("SummonedCount"));
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.put("Inventory", (Tag)this.inventory.createTag((HolderLookup.Provider)this.level().registryAccess()));
        pCompound.putInt("SummonedCount", this.getSummonedCount());
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 2;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.CORNELIUS_KEEP_CHUNK_LOADED;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemStack = this.inventory.getItem(i);
                if (itemStack.isEmpty()) continue;
                this.spawnAtLocation(itemStack);
            }
        }
    }

    public static boolean checkCorneliusSpawnRules(EntityType<CorneliusEntity> cornelius, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pRandom.nextInt(20) == 0 && CorneliusEntity.checkMobSpawnRules(cornelius, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom) && CorneliusEntity.checkAnimalSpawnRules(cornelius, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public void containerChanged(@NotNull Container container) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.setAnimation(this.getSitVariation() == 0 ? this.SIT : this.SIT2);
        } else if (this.getAttackType() == 1) {
            event.setAnimation(this.SUMMON);
        } else if (this.getAttackType() == 2) {
            event.setAnimation(this.SUMMON2);
        } else if (this.getAttackType() == 3) {
            event.setAnimation(this.SUMMON3);
        } else if (this.getCycleCount() >= 0) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }
}

