/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.container.SoulMageContainerMenu;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionFollowOwnerGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionRandomStrollGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsHurtTargetGoal;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageBlackHoleGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageBraceGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageFireMarkGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageHealRingGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageIceShardGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageMagicRayGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageNaginataGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageStoneSpikesGoal;
import dev.xylonity.companions.common.entity.ai.mage.goal.SoulMageTornadoGoal;
import dev.xylonity.companions.common.entity.summon.LivingCandleEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class SoulMageEntity
extends CompanionEntity
implements ContainerListener {
    public SimpleContainer inventory;
    private final RawAnimation SIT = RawAnimation.begin().thenPlay("sit");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final EntityDataAccessor<Integer> SIT_VARIATION = SynchedEntityData.defineId(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.defineId(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.defineId(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<String> ATTACK_ANIMATION_NAME = SynchedEntityData.defineId(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> CANDLE_COUNT = SynchedEntityData.defineId(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BOOK_ID = SynchedEntityData.defineId(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> CURRENT_ATTACK_TYPE = SynchedEntityData.defineId(SoulMageEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final int MAX_CANDLES_COUNT = 6;
    public List<LivingCandleEntity> candles = new LinkedList<LivingCandleEntity>();
    public static final Map<String, int[]> ATTACK_COLORS = Map.of("MAGIC_RAY", new int[]{173, 216, 230}, "BLACK_HOLE", new int[]{128, 0, 128}, "STONE_SPIKES", new int[]{139, 69, 19}, "HEAL_RING", new int[]{110, 252, 85}, "ICE_SHARD", new int[]{134, 236, 255}, "FIRE_MARK", new int[]{225, 45, 45}, "TORNADO", new int[]{242, 242, 242}, "NONE", new int[]{169, 134, 60});

    public SoulMageEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.createInventory();
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void createInventory() {
        SimpleContainer oldInv = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (oldInv != null) {
            int min = Math.min(oldInv.getContainerSize(), this.inventory.getContainerSize());
            for (int i = 0; i < min; ++i) {
                ItemStack stack = oldInv.getItem(i);
                this.inventory.setItem(i, stack.copy());
            }
        }
        this.inventory.addListener((ContainerListener)this);
        this.updateContainerEquipment();
    }

    protected int getInventorySize() {
        return 3;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, (Goal)new SoulMageMagicRayGoal(this, 70, 160));
        this.goalSelector.addGoal(3, (Goal)new SoulMageBlackHoleGoal(this, 70, 160));
        this.goalSelector.addGoal(3, (Goal)new SoulMageStoneSpikesGoal(this, 70, 160));
        this.goalSelector.addGoal(3, (Goal)new SoulMageHealRingGoal(this, 70, 160));
        this.goalSelector.addGoal(3, (Goal)new SoulMageIceShardGoal(this, 70, 160));
        this.goalSelector.addGoal(3, (Goal)new SoulMageFireMarkGoal(this, 70, 160));
        this.goalSelector.addGoal(3, (Goal)new SoulMageTornadoGoal(this, 70, 160));
        this.goalSelector.addGoal(3, (Goal)new SoulMageBraceGoal(this, 70, 160));
        this.goalSelector.addGoal(3, (Goal)new SoulMageNaginataGoal(this, 70, 160));
        this.goalSelector.addGoal(4, (Goal)new CompanionFollowOwnerGoal(this, 0.6, 6.0f, 2.0f, false));
        this.goalSelector.addGoal(4, (Goal)new CompanionRandomStrollGoal(this, 0.43));
        this.goalSelector.addGoal(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new CompanionsHurtTargetGoal(this));
    }

    @Override
    public boolean hurt(DamageSource pSource, float pAmount) {
        if (pAmount > this.getHealth() && !this.candles.isEmpty()) {
            LivingCandleEntity candle = this.candles.remove(0);
            this.setCandleCount(this.getCandleCount() - 1);
            candle.doKill();
            return false;
        }
        return super.hurt(pSource, pAmount);
    }

    public String getCurrentAttackType() {
        return (String)this.entityData.get(CURRENT_ATTACK_TYPE);
    }

    public void setCurrentAttackType(String attackType) {
        this.entityData.set(CURRENT_ATTACK_TYPE, (Object)attackType);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, CompanionsConfig.SOUL_MAGE_MAX_LIFE).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.55f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    public void setCandleCount(int candleCount) {
        this.entityData.set(CANDLE_COUNT, (Object)candleCount);
    }

    public int getCandleCount() {
        return (Integer)this.entityData.get(CANDLE_COUNT);
    }

    public String getAttackAnimationName() {
        return (String)this.entityData.get(ATTACK_ANIMATION_NAME);
    }

    public void setAttackAnimationName(String s) {
        this.entityData.set(ATTACK_ANIMATION_NAME, (Object)s);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.entityData.set(IS_ATTACKING, (Object)attacking);
    }

    public int getBookId() {
        return (Integer)this.entityData.get(BOOK_ID);
    }

    public void setBookId(int id) {
        this.entityData.set(BOOK_ID, (Object)id);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SIT_VARIATION, (Object)0);
        builder.define(IS_ATTACKING, (Object)false);
        builder.define(DATA_ID_FLAGS, (Object)0);
        builder.define(ATTACK_ANIMATION_NAME, (Object)"");
        builder.define(CANDLE_COUNT, (Object)0);
        builder.define(BOOK_ID, (Object)-1);
        builder.define(CURRENT_ATTACK_TYPE, (Object)"NONE");
    }

    @Nullable
    public LivingEntity getOwner() {
        return super.getOwner();
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && this.getOwner() == player && player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            if (!this.level().isClientSide) {
                player.openMenu(new MenuProvider(){

                    public Component getDisplayName() {
                        return SoulMageEntity.this.getName();
                    }

                    @Nullable
                    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                        return new SoulMageContainerMenu(i, inventory, SoulMageEntity.this);
                    }
                }, buf -> buf.writeInt(this.getId()));
                this.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.handleDefaultMainActionAndHeal(player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.inventory.fromTag(pCompound.getList("Inventory", 10), (HolderLookup.Provider)this.level().registryAccess());
        if (pCompound.contains("BookEntityId")) {
            this.entityData.set(BOOK_ID, (Object)pCompound.getInt("BookEntityId"));
        }
        this.setBookId(pCompound.getInt("BookId"));
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.put("Inventory", (Tag)this.inventory.createTag((HolderLookup.Provider)this.level().registryAccess()));
        pCompound.putInt("BookId", this.getBookId());
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.MAGE_IDLE.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return CompanionsSounds.MAGE_DEATH.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource pDamageSource) {
        return CompanionsSounds.MAGE_HURT.get();
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound(CompanionsSounds.MAGE_STEP.get(), 0.2f, 1.0f);
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 1;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return CompanionsConfig.SOUL_MAGE_KEEP_CHUNK_LOADED;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 1, this::attackPredicate));
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        if (this.isAttacking() && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().forceAnimationReset();
            event.setAnimation(RawAnimation.begin().thenPlay(this.getAttackAnimationName()));
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getMainAction() == 0) {
            event.setAnimation(this.SIT);
        } else if (event.isMoving()) {
            event.setAnimation(this.WALK);
        } else {
            event.setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void aiStep() {
        this.setNoMovement(this.isAttacking());
        super.aiStep();
    }

    public void containerChanged(@NotNull Container container) {
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.level().isClientSide) {
            this.setFlag(4, !this.inventory.getItem(0).isEmpty());
        }
    }

    protected void setFlag(int $$0, boolean $$1) {
        byte $$2 = (Byte)this.entityData.get(DATA_ID_FLAGS);
        if ($$1) {
            this.entityData.set(DATA_ID_FLAGS, (Object)((byte)($$2 | $$0)));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (Object)((byte)($$2 & ~$$0)));
        }
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemStack = this.inventory.getItem(i);
                if (itemStack.isEmpty()) continue;
                this.spawnAtLocation(itemStack);
            }
        }
    }
}

