/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.hostile.BrokenDinamoEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IllagerGolemEntity
extends Raider
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public List<Entity> visibleEntities = new ArrayList<Entity>();
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("roll");
    private final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(IllagerGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ANIMATION_START_TICK = SynchedEntityData.defineId(IllagerGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> TICKCOUNT = SynchedEntityData.defineId(IllagerGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> TEST_TIMER = SynchedEntityData.defineId(IllagerGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int TIME_PER_ACTIVATION = 60;
    public static final int ELECTRICAL_CHARGE_DURATION = 8;

    public IllagerGolemEntity(EntityType<? extends Raider> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.noCulling = true;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        return new GroundNavigator((Mob)this, pLevel);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 0.01f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier setAttributes() {
        return Raider.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.FOLLOW_RANGE, 35.0).build();
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("TickCount", this.getTickCount());
        tag.putInt("AnimationStartTick", this.getAnimationStartTick());
    }

    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.setAnimationStartTick(tag.getInt("TickCount"));
        this.setAnimationStartTick(tag.getInt("AnimationStartTick"));
    }

    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("TickCount")) {
            this.setTickCount(tag.getInt("TickCount"));
        } else {
            this.setTickCount(0);
        }
        if (tag.contains("AnimationStartTick")) {
            this.setAnimationStartTick(tag.getInt("AnimationStartTick"));
        } else {
            this.setAnimationStartTick(0);
        }
    }

    public int getAnimationStartTick() {
        return (Integer)this.entityData.get(TEST_TIMER);
    }

    public void setAnimationStartTick(int tick) {
        this.entityData.set(TEST_TIMER, (Object)tick);
    }

    public int getTickCount() {
        return (Integer)this.entityData.get(TICKCOUNT);
    }

    public void setTickCount(int tick) {
        this.entityData.set(TICKCOUNT, (Object)tick);
    }

    @NotNull
    public SoundEvent getCelebrateSound() {
        return SoundEvents.PILLAGER_CELEBRATE;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.setTickCount(this.tickCount);
        }
        if (this.getTickCount() % 60 == 0) {
            this.setActive(true);
        }
        if (this.isActive() && this.getTickCount() % 60 >= 8) {
            this.setActive(false);
            this.visibleEntities.clear();
        }
        if (!this.isAlive()) {
            this.setActive(false);
        }
        if (this.isActive()) {
            this.searchAndAttack();
        }
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            BrokenDinamoEntity dinamo = (BrokenDinamoEntity)CompanionsEntities.BROKEN_DINAMO.get().create(this.level());
            if (dinamo != null && this.level().random.nextFloat() < 0.15f && !this.level().isClientSide) {
                dinamo.moveTo(this.position());
                dinamo.setLifetime(new Random().nextInt(6000, 10000));
                this.level().addFreshEntity((Entity)dinamo);
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    private void searchAndAttack() {
        this.visibleEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(10.0), entity -> {
            if (entity instanceof Monster) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.isCreative() && !player.isSpectator();
            }
            return entity instanceof LivingEntity;
        }).stream().filter(arg_0 -> ((IllagerGolemEntity)this).hasLineOfSight(arg_0)).collect(Collectors.toList());
        if (!this.visibleEntities.isEmpty()) {
            if (this.level().isClientSide()) {
                double radius = 0.42;
                for (int i = 0; i < 360; i += 120) {
                    double rad = Math.toRadians(i);
                    double particleX = this.position().x + radius * Math.cos(rad);
                    double particleZ = this.position().z + radius * Math.sin(rad);
                    this.level().addParticle((ParticleOptions)CompanionsParticles.ILLAGER_GOLEM_SPARK.get(), particleX, this.position().y() + (double)this.getBbHeight() - 0.6, particleZ, 0.0, 0.35, 0.0);
                }
            }
            int elapsed = this.getTickCount() - this.getAnimationStartTick();
            if (!this.level().isClientSide && elapsed >= 3 && elapsed < 8) {
                for (Entity entity2 : this.visibleEntities) {
                    LivingEntity e;
                    if (!(entity2 instanceof LivingEntity) || Util.areEntitiesLinked((Entity)this, (Entity)(e = (LivingEntity)entity2))) continue;
                    this.doHurtTarget((Entity)e);
                }
            }
        }
    }

    public void setActive(boolean active) {
        if (active && !this.isActive()) {
            this.setAnimationStartTick(this.getTickCount());
        }
        this.entityData.set(ACTIVE, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.entityData.get(ACTIVE);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ACTIVE, (Object)false);
        builder.define(ANIMATION_START_TICK, (Object)0);
        builder.define(TEST_TIMER, (Object)0);
        builder.define(TICKCOUNT, (Object)0);
    }

    public void applyRaidBuffs(ServerLevel serverLevel, int i, boolean b) {
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        super.playStepSound(pPos, pState);
        this.playSound(CompanionsSounds.DINAMO_STEP.get(), 0.07875f, 1.0f);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return CompanionsSounds.DINAMO_IDLE.get();
    }

    protected void playHurtSound(@NotNull DamageSource pSource) {
        this.playSound(CompanionsSounds.DINAMO_HURT.get(), 0.25f, 1.0f);
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return CompanionsSounds.DINAMO_DEATH.get();
    }

    public int getAmbientSoundInterval() {
        return 320;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "attackcontroller", 1, this::attackPredicate));
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED) && this.isActive() && !this.visibleEntities.isEmpty()) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(this.SHOOT);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

