/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.FrogHealProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.mixin.CompanionsProjectileAccessor;
import dev.xylonity.companions.registry.CompanionsParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodSlashProjectile
extends FrogHealProjectile {
    public BloodSlashProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    @Override
    public float getDefaultSpeed() {
        return (float)CompanionsConfig.BLOOD_SLASH_SPEED;
    }

    @Override
    public float getDefaultLerp() {
        return 0.0f;
    }

    @Override
    public void spawnRibbon() {
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide && (this.tickCount % 20 == 0 || this.tickCount == 1)) {
            this.spawnSidedRibbon();
        }
    }

    private void spawnSidedRibbon() {
        Vec3 dir = this.getDeltaMovement().normalize();
        if (dir.lengthSqr() < 1.0E-6) {
            return;
        }
        Vec3 perp = new Vec3(-dir.z, 0.0, dir.x).normalize().scale(1.5);
        double y = this.getY();
        Vec3 left = new Vec3(this.getX(), y, this.getZ()).subtract(perp);
        Companions.PROXY.spawnSidedRibbonTrail((Entity)this, this.level(), left.x, left.y, left.z, 0.5686275f, 0.078431375f, 0.078431375f, 0.0f, 0.1725f, 0);
        Vec3 right = new Vec3(this.getX(), y, this.getZ()).add(perp);
        Companions.PROXY.spawnSidedRibbonTrail((Entity)this, this.level(), right.x, right.y, right.z, 0.5686275f, 0.078431375f, 0.078431375f, 0.0f, 0.1725f, 1);
    }

    @Override
    protected boolean canHitEntity(@NotNull Entity pTarget) {
        if (Util.areEntitiesLinked((Entity)this, pTarget)) {
            return false;
        }
        if (!pTarget.canBeHitByProjectile()) {
            return false;
        }
        Entity entity = this.getOwner();
        return entity == null || ((CompanionsProjectileAccessor)((Object)this)).getLeftOwner() || !entity.isPassengerOfSameVehicle(pTarget);
    }

    @Override
    public void spawnParticles() {
    }

    @Override
    protected void onHitEntity(@NotNull EntityHitResult pResult) {
        LivingEntity entity;
        Entity e = pResult.getEntity();
        if (e instanceof LivingEntity && !Util.areEntitiesLinked((Entity)this, (Entity)(entity = (LivingEntity)e))) {
            entity.hurt(this.damageSources().magic(), (float)CompanionsConfig.BLOOD_SLASH_DAMAGE);
        }
        this.remove(Entity.RemovalReason.KILLED);
    }

    @Override
    public void remove(@NotNull Entity.RemovalReason pReason) {
        if (!this.level().isClientSide) {
            this.spawnRemoveParticles();
            this.level().playSound(null, this.blockPosition(), SoundEvents.AMETHYST_BLOCK_HIT, SoundSource.NEUTRAL);
        }
        super.remove(pReason);
    }

    private void spawnRemoveParticles() {
        for (int i = 0; i < 15; ++i) {
            double dx = (this.random.nextDouble() - 0.5) * 1.15;
            double dy = (this.random.nextDouble() - 0.5) * 1.15;
            double dz = (this.random.nextDouble() - 0.5) * 1.15;
            Level level = this.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1);
            if (!(level2.random.nextFloat() < 0.35f)) continue;
            level2.sendParticles((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.getX(), this.getY() + (double)this.getBbHeight() * Math.random(), this.getZ(), 1, dx, dy, dz, 0.1225);
        }
    }

    @Override
    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(0.5), this::canHitEntity);
    }

    protected void onHitBlock(@NotNull BlockHitResult pResult) {
        super.onHitBlock(pResult);
        this.discard();
    }
}

