/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BraceProjectile
extends BaseProjectile {
    private static final double BOUNCE_DAMPING_VERTICAL = 0.6;
    private static final double BOUNCE_DAMPING_HORIZONTAL = 0.7;
    private static final int MAX_BOUNCES = 5;
    private static final double MIN_UPWARD = 0.4;
    private final List<Integer> hitEntities = new ArrayList<Integer>();
    private int entityBounces = 0;
    private int blockBounces = 0;

    public BraceProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
        this.noPhysics = false;
    }

    @Override
    public void tick() {
        double blockDist;
        super.tick();
        if (this.tickCount > this.getLifetime() || this.entityBounces >= 5) {
            if (!this.level().isClientSide) {
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        Vec3 vel = this.getDeltaMovement().add(0.0, -0.03, 0.0).scale(0.98);
        Vec3 start = this.position();
        Vec3 end = start.add(vel);
        HitResult entityHit = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        BlockHitResult blockHit = this.level().clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        double entityDist = entityHit.getType() == HitResult.Type.ENTITY ? entityHit.getLocation().distanceToSqr(start) : Double.MAX_VALUE;
        double d = blockDist = blockHit.getType() != HitResult.Type.MISS ? blockHit.getLocation().distanceToSqr(start) : Double.MAX_VALUE;
        if (entityDist < blockDist) {
            this.handleEntityHit((EntityHitResult)entityHit);
        } else if (blockDist < Double.MAX_VALUE) {
            this.handleBlockHit(blockHit);
        } else {
            this.move(vel);
        }
        if (this.tickCount % 3 == 0) {
            this.level().addParticle((ParticleOptions)CompanionsParticles.EMBER.get(), this.getX(), this.getY() - (double)this.getBbHeight() * 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
        if (this.level().isClientSide && (this.tickCount % 50 == 0 || this.tickCount == 1)) {
            float r = 0.98039216f;
            float g = (float)(203 + this.level().random.nextInt(10)) / 255.0f;
            float b = (float)(138 + this.level().random.nextInt(10)) / 255.0f;
            Companions.PROXY.spawnGenericRibbonTrail((Entity)this, this.level(), this.getX(), this.getY(), this.getZ(), r, g, b, 0.0f, 0.35f);
        }
    }

    private void handleEntityHit(EntityHitResult hit) {
        LivingEntity target;
        Entity entity = hit.getEntity();
        if (!(entity instanceof LivingEntity) || Util.areEntitiesLinked((Entity)(target = (LivingEntity)entity), (Entity)this) || this.hitEntities.contains(entity.getId())) {
            this.move(this.getDeltaMovement());
            return;
        }
        target.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)CompanionsConfig.BRACE_PROJECTILE_DAMAGE);
        target.setRemainingFireTicks(this.random.nextInt(1, 10) * 20);
        this.hitEntities.add(target.getId());
        ++this.entityBounces;
        this.setPos(hit.getLocation());
        Vec3 bouncePos = new Vec3(target.getX(), target.getEyeY(), target.getZ());
        this.setPos(bouncePos);
        this.setDeltaMovement(Vec3.ZERO);
        if (this.entityBounces >= 5) {
            this.spawnParticles();
            this.discard();
            return;
        }
        LivingEntity next = this.findNextTarget();
        if (next == null) {
            this.spawnParticles();
            this.discard();
            return;
        }
        Vec3 direction = next.position().add(0.0, (double)next.getBbHeight() * 0.5, 0.0).subtract(this.position()).normalize();
        if (direction.y < 0.4) {
            direction = new Vec3(direction.x, 0.4, direction.z).normalize();
        }
        this.setDeltaMovement(direction.scale(0.6));
    }

    private void handleBlockHit(BlockHitResult hit) {
        Direction face = hit.getDirection();
        Vec3 normal = new Vec3((double)face.getStepX(), (double)face.getStepY(), (double)face.getStepZ());
        Vec3 reflected = this.getDeltaMovement().subtract(normal.scale(2.0 * this.getDeltaMovement().dot(normal)));
        reflected = face.getAxis().isVertical() ? new Vec3(reflected.x, reflected.y * 0.6, reflected.z) : new Vec3(reflected.x * 0.7, reflected.y, reflected.z * 0.7);
        ++this.blockBounces;
        if (this.blockBounces >= 5) {
            reflected = Vec3.ZERO;
        }
        this.setPos(hit.getLocation().add(normal.scale(0.02)));
        this.move(reflected);
    }

    private void spawnSmokeParticles() {
        for (int i = 0; i < 6; ++i) {
            double speedX = (this.random.nextDouble() - 0.5) * 0.1;
            double speedY = (this.random.nextDouble() - 0.5) * 0.1;
            double speedZ = (this.random.nextDouble() - 0.5) * 0.1;
            this.level().addParticle((ParticleOptions)CompanionsParticles.EMBER.get(), this.getX(), this.getY(), this.getZ(), speedX, speedY, speedZ);
        }
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 3) {
            this.spawnSmokeParticles();
        } else {
            super.handleEntityEvent(pId);
        }
    }

    private void spawnParticles() {
        if (!this.level().isClientSide) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            float speed = 0.1f;
            this.level().addParticle((ParticleOptions)CompanionsParticles.EMBER.get(), this.getX(), this.getY(), this.getZ(), (this.random.nextDouble() - 0.5) * (double)speed, (this.random.nextDouble() - 0.5) * (double)speed, (this.random.nextDouble() - 0.5) * (double)speed);
        }
    }

    private LivingEntity findNextTarget() {
        return this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(10.0), e -> e.isAlive() && !Util.areEntitiesLinked((Entity)this, (Entity)e) && !this.hitEntities.contains(e.getId())).stream().min(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)this))).orElse(null);
    }

    private void move(Vec3 vel) {
        if (this.onGround() && Math.abs(vel.y) < 0.001 && vel.horizontalDistanceSqr() < 9.0E-4) {
            vel = Vec3.ZERO;
        }
        this.setDeltaMovement(vel);
        this.move(MoverType.SELF, vel);
    }

    protected boolean canHitEntity(@NotNull Entity e) {
        if (Util.areEntitiesLinked((Entity)this, e)) {
            return false;
        }
        if (e == this.getOwner() || e == this) {
            return false;
        }
        if (this.hitEntities.contains(e.getId())) {
            return false;
        }
        return e instanceof LivingEntity;
    }

    public void playerTouch(@NotNull Player player) {
    }

    @Override
    protected int baseLifetime() {
        return 200;
    }
}

